# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
import typing
from ..core.serialization import FieldMetadata
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class PaginatedExtractionConfig(UniversalBaseModel):
    interaction_mode: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="interactionMode")] = (
        pydantic.Field(default=None)
    )
    """
    The mode to use for interaction. If set to 'auto', Airtop AI will automatically choose the most cost-effective interaction mode. If set to 'accurate', the request might be slower, but more likely to be accurate. Whereas, 'cost-efficient' will be cheaper and speed things up, but may reduce accuracy.
    """

    output_schema: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="outputSchema")] = (
        pydantic.Field(default=None)
    )
    """
    JSON schema defining the structure of the output. If not provided, the format of the output might vary.
    """

    pagination_mode: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="paginationMode")] = (
        pydantic.Field(default=None)
    )
    """
    The mode to use for pagination. If set to 'auto', Airtop AI will automatically look for pagination links first and then attempt infinite scrolling to load more content. If set to 'paginated', Airtop AI will follow pagination links to load more content. If set to 'infinite-scroll', Airtop AI will scroll the page to load more content.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
