# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
import typing
from ..core.serialization import FieldMetadata
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ScreenshotConfig(UniversalBaseModel):
    max_height: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="maxHeight")] = pydantic.Field(
        default=None
    )
    """
    Maximum height of the screenshot in pixels. The screenshot will be scaled down to fit within this height if necessary, preserving the aspect ratio.
    """

    max_width: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="maxWidth")] = pydantic.Field(
        default=None
    )
    """
    Maximum width of the screenshot in pixels. The screenshot will be scaled down to fit within this width if necessary, preserving the aspect ratio.
    """

    quality: typing.Optional[int] = pydantic.Field(default=None)
    """
    JPEG quality (1-100). Note that this option is still in development and may not work as expected.
    """

    scope: typing.Optional[typing.Literal["viewport"]] = pydantic.Field(default=None)
    """
    Whether to capture the current viewport or whole page. Only viewport is currently supported.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
