# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
import typing
from ..core.serialization import FieldMetadata
from .page_query_config import PageQueryConfig
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class SessionPageQueryHandlerRequestBody(UniversalBaseModel):
    client_request_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="clientRequestId")] = None
    configuration: typing.Optional[PageQueryConfig] = pydantic.Field(default=None)
    """
    Request configuration
    """

    cost_threshold_credits: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="costThresholdCredits")
    ] = pydantic.Field(default=None)
    """
    A credit threshold that, once exceeded, will cause the operation to be cancelled. Note that this is *not* a hard limit, but a threshold that is checked periodically during the course of fulfilling the request. A default threshold is used if not specified, but you can use this option to increase or decrease as needed. Set to 0 to disable this feature entirely (not recommended).
    """

    follow_pagination_links: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="followPaginationLinks")
    ] = pydantic.Field(default=None)
    """
    Make a best effort attempt to load more content items than are originally displayed on the page, e.g. by following pagination links, clicking controls to load more content, utilizing infinite scrolling, etc. This can be quite a bit more costly, but may be necessary for sites that require additional interaction to show the needed results. You can provide constraints in your prompt (e.g. on the total number of pages or results to consider).
    """

    prompt: str = pydantic.Field()
    """
    The prompt to submit about the content in the browser window.
    """

    time_threshold_seconds: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="timeThresholdSeconds")
    ] = pydantic.Field(default=None)
    """
    A time threshold in seconds that, once exceeded, will cause the operation to be cancelled. Note that this is *not* a hard limit, but a threshold that is checked periodically during the course of fulfilling the request. A default threshold is used if not specified, but you can use this option to increase or decrease as needed. Set to 0 to disable this feature entirely (not recommended).
    
    This setting does not extend the maximum session duration provided at the time of session creation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
