# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .error_body import ErrorBody
import pydantic
import typing_extensions
from ..core.serialization import FieldMetadata
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class WindowEventMessage(UniversalBaseModel):
    error: typing.Optional[ErrorBody] = pydantic.Field(default=None)
    """
    Error message
    """

    event: str = pydantic.Field()
    """
    Event name
    """

    event_data: typing_extensions.Annotated[
        typing.Optional[typing.Optional[typing.Any]], FieldMetadata(alias="eventData")
    ] = None
    event_id: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="eventId")] = pydantic.Field(
        default=None
    )
    """
    Event ID
    """

    event_time: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="eventTime")] = pydantic.Field()
    """
    Date and Time of the event
    """

    id: str = pydantic.Field()
    """
    ID of the session
    """

    window_id: typing_extensions.Annotated[str, FieldMetadata(alias="windowId")] = pydantic.Field()
    """
    Window ID
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
