# Generated by Django 4.2.9 on 2024-01-30 06:13

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='HandHistory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('variant', models.CharField(choices=[('FT', "Fixed-limit Texas hold 'em"), ('NT', "No-limit Texas hold 'em"), ('NS', "No-limit short-deck hold 'em"), ('PO', "Pot-limit Omaha hold 'em"), ('FO/8', "Fixed-limit Omaha hold 'em high/low-split eight-or-better"), ('F7S', 'Fixed-limit seven card stud'), ('F7S/8', 'Fixed-limit seven card stud high/low-split eight-or-better'), ('FR', 'Fixed-limit razz'), ('N2L1D', 'No-limit deuce-to-seven lowball single draw'), ('F2L3D', 'Fixed-limit deuce-to-seven lowball triple draw'), ('FB', 'Fixed-limit badugi')], max_length=255)),
                ('ante_trimming_status', models.BooleanField(default=False)),
                ('antes', models.JSONField()),
                ('blinds_or_straddles', models.JSONField(blank=True, null=True)),
                ('bring_in', models.JSONField(blank=True, null=True)),
                ('small_bet', models.JSONField(blank=True, null=True)),
                ('big_bet', models.JSONField(blank=True, null=True)),
                ('min_bet', models.JSONField(blank=True, null=True)),
                ('starting_stacks', models.JSONField()),
                ('actions', models.JSONField()),
                ('author', models.CharField(blank=True, max_length=255, null=True)),
                ('event', models.CharField(blank=True, max_length=255, null=True)),
                ('url', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('city', models.CharField(blank=True, max_length=255, null=True)),
                ('region', models.CharField(blank=True, max_length=255, null=True)),
                ('postal_code', models.CharField(blank=True, max_length=255, null=True)),
                ('country', models.CharField(blank=True, max_length=255, null=True)),
                ('time', models.TimeField(blank=True, null=True)),
                ('time_zone', models.CharField(blank=True, max_length=255, null=True)),
                ('day', models.PositiveBigIntegerField(blank=True, null=True)),
                ('month', models.PositiveBigIntegerField(blank=True, null=True)),
                ('year', models.PositiveBigIntegerField(blank=True, null=True)),
                ('hand', models.PositiveBigIntegerField(blank=True, null=True)),
                ('level', models.PositiveBigIntegerField(blank=True, null=True)),
                ('seats', models.JSONField(blank=True, null=True)),
                ('seat_count', models.PositiveBigIntegerField(blank=True, null=True)),
                ('table', models.PositiveBigIntegerField(blank=True, null=True)),
                ('players', models.JSONField(blank=True, null=True)),
                ('finishing_stacks', models.JSONField(blank=True, null=True)),
                ('currency', models.CharField(blank=True, max_length=255, null=True)),
                ('time_limit', models.JSONField(blank=True, null=True)),
                ('time_banks', models.JSONField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'hand histories',
            },
        ),
        migrations.CreateModel(
            name='Poker',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('variant', models.CharField(choices=[('FT', "Fixed-limit Texas hold 'em"), ('NT', "No-limit Texas hold 'em"), ('NS', "No-limit short-deck hold 'em"), ('PO', "Pot-limit Omaha hold 'em"), ('FO/8', "Fixed-limit Omaha hold 'em high/low-split eight-or-better"), ('F7S', 'Fixed-limit seven card stud'), ('F7S/8', 'Fixed-limit seven card stud high/low-split eight-or-better'), ('FR', 'Fixed-limit razz'), ('N2L1D', 'No-limit deuce-to-seven lowball single draw'), ('F2L3D', 'Fixed-limit deuce-to-seven lowball triple draw'), ('FB', 'Fixed-limit badugi')], max_length=255)),
                ('ante_trimming_status', models.BooleanField(default=False)),
                ('raw_antes', models.JSONField()),
                ('raw_blinds_or_straddles', models.JSONField(blank=True, null=True)),
                ('bring_in', models.JSONField(blank=True, null=True)),
                ('small_bet', models.JSONField(blank=True, null=True)),
                ('big_bet', models.JSONField(blank=True, null=True)),
                ('min_bet', models.JSONField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'poker',
            },
        ),
        migrations.CreateModel(
            name='Table',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('seat_count', models.PositiveBigIntegerField()),
                ('min_starting_stack', models.JSONField(blank=True, null=True)),
                ('max_starting_stack', models.JSONField(blank=True, null=True)),
                ('game', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='cardroom.poker')),
            ],
        ),
        migrations.CreateModel(
            name='CashGame',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_bank', models.FloatField()),
                ('time_bank_increment', models.FloatField()),
                ('state_construction_timeout', models.FloatField()),
                ('state_destruction_timeout', models.FloatField()),
                ('idle_timeout', models.FloatField()),
                ('standing_pat_timeout', models.FloatField()),
                ('betting_timeout', models.FloatField()),
                ('hole_cards_showing_or_mucking_timeout', models.FloatField()),
                ('table', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='cardroom.table')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
