<a id="boto3-stubs"></a>

# boto3-stubs

[![PyPI - boto3-stubs](https://img.shields.io/pypi/v/boto3-stubs.svg?color=blue)](https://pypi.org/project/boto3-stubs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/boto3-stubs.svg?color=blue)](https://pypi.org/project/boto3-stubs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/boto3-stubs?color=blue)](https://pypistats.org/packages/boto3-stubs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3 1.18.47](https://boto3.amazonaws.com/v1/documentation/api/1.18.47/index.html)
compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.3.1](https://github.com/vemel/mypy_boto3_builder).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [boto3-stubs](#boto3-stubs)
  - [How to install](#how-to-install)
    - [Basic](#basic)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
    - [Explicit type annotations](#explicit-type-annotations)
    - [Pylint compatibility](#pylint-compatibility)
  - [How it works](#how-it-works)
  - [What's new](#what%27s-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Submodules](#submodules)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="basic"></a>

### Basic

Install `boto3-stubs` to add type annotations for `boto3` package.

```bash
# install type annotations only for boto3 and botocore
python -m pip install boto3-stubs

# install `boto3` type annotations
# for ec2, s3, rds, lambda, sqs, dynamo and cloudformation
# Consumes ~7 MB of space
python -m pip install 'boto3-stubs[essential]'

# or install annotations for services you use
python -m pip install 'boto3-stubs[acm,apigateway]'
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
# uninstall boto3-stubs
python -m pip uninstall -y boto3-stubs botocore-stubs

# uninstall submodules
python -m pip freeze | grep mypy-boto3 | xargs python -m pip uninstall -y
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs` with services you use in your environment:
  `python -m pip install 'boto3-stubs[s3,ec2]'`

Both type checking and auto-complete should work for installed `boto3`
services. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs` with services you use in your environment:
  `python -m pip install 'boto3-stubs[s3,ec2]'`
- Install `mypy_boto3_builder`: `pip install mypy_boto3_builder`
- Generate stubs in `<project_root>/typings` directory for services you use

```bash
python -m mypy_boto3_builder --installed --skip-services typings -d -s s3 ec2
```

- Add `<project_root>/typings` folder to your
  [Interpreter Paths](https://www.jetbrains.com/help/pycharm/stubs.html#reuse-stubs)

Since stubs are stored in your project root, you do not need to re-generate
them after update.

<a id="emacs"></a>

### Emacs

- Install `boto-stubs` with services you use in your environment:
  `python -m pip install 'boto3-stubs[s3,ec2]'`
- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

<a id="sublime-text"></a>

### Sublime Text

- Install `boto-stubs` with services you use in your environment:
  `python -m pip install 'boto3-stubs[s3,ec2]'`
- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package
- Make sure emacs uses the environment where you have installed `boto3-stubs`

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs` with services you use in your environment:
  `python -m pip install 'boto3-stubs[s3,ec2]'`
- Run `mypy` as usual

Type checking should work for installed `boto3` services. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs` with services you use in your environment:
  `python -m pip install 'boto3-stubs[s3,ec2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for installed `boto3` services. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

### Explicit type annotations

To speed up type checking and auto-complete, you can set types explicitly.

```python
import boto3
from boto3.session import Session

from mypy_boto3_ec2.client import EC2Client
from mypy_boto3_ec2.service_resource import EC2ServiceResource
from mypy_boto3_ec2.waiter import BundleTaskCompleteWaiter
from mypy_boto3_ec2.paginator import DescribeVolumesPaginator

session = Session(region_name="us-west-1")

ec2_client: EC2Client = boto3.client("ec2", region_name="us-west-1")
ec2_resource: EC2ServiceResource = session.resource("ec2")

bundle_task_complete_waiter: BundleTaskCompleteWaiter = ec2_client.get_waiter("bundle_task_complete")
describe_volumes_paginator: DescribeVolumesPaginator = ec2_client.get_paginator("describe_volumes")
```

<a id="pylint-compatibility"></a>

### Pylint compatibility

It is totally safe to use `TYPE_CHECKING` flag in order to avoid `boto3-stubs`
dependency in production. However, there is an issue in `pylint` that it
complains about undefined variables. To fix it, set all types to `object` in
non-`TYPE_CHECKING` mode.

```python
import boto3
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from mypy_boto3_ec2 import EC2Client, EC2ServiceResource
    from mypy_boto3_ec2.waiters import BundleTaskCompleteWaiter
    from mypy_boto3_ec2.paginators import DescribeVolumesPaginator
else:
    EC2Client = object
    EC2ServiceResource = object
    BundleTaskCompleteWaiter = object
    DescribeVolumesPaginator = object

...
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3` library
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client` type annotations for each service
- `ServiceResource` type annotations for each service
- `Resource` type annotations for each service
- `Waiter` type annotations for each service
- `Paginator` type annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/vemel/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`boto3-stubs` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="submodules"></a>

## Submodules

developers

- `boto3-stubs[all]` - Type annotations for all 279 services.
- `boto3-stubs[essential]` - Type annotations for
  [CloudFormation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudformation/),
  [DynamoDB](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/),
  [EC2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ec2/),
  [Lambda](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lambda/),
  [RDS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rds/),
  [S3](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3/) and
  [SQS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sqs/) services.
- `boto3-stubs[accessanalyzer]` - Type annotations for
  [AccessAnalyzer](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_accessanalyzer/)
  service.
- `boto3-stubs[acm]` - Type annotations for
  [ACM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_acm/) service.
- `boto3-stubs[acm-pca]` - Type annotations for
  [ACMPCA](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_acm_pca/)
  service.
- `boto3-stubs[alexaforbusiness]` - Type annotations for
  [AlexaForBusiness](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_alexaforbusiness/)
  service.
- `boto3-stubs[amp]` - Type annotations for
  [PrometheusService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_amp/)
  service.
- `boto3-stubs[amplify]` - Type annotations for
  [Amplify](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_amplify/)
  service.
- `boto3-stubs[amplifybackend]` - Type annotations for
  [AmplifyBackend](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_amplifybackend/)
  service.
- `boto3-stubs[apigateway]` - Type annotations for
  [APIGateway](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_apigateway/)
  service.
- `boto3-stubs[apigatewaymanagementapi]` - Type annotations for
  [ApiGatewayManagementApi](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_apigatewaymanagementapi/)
  service.
- `boto3-stubs[apigatewayv2]` - Type annotations for
  [ApiGatewayV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_apigatewayv2/)
  service.
- `boto3-stubs[appconfig]` - Type annotations for
  [AppConfig](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appconfig/)
  service.
- `boto3-stubs[appflow]` - Type annotations for
  [Appflow](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appflow/)
  service.
- `boto3-stubs[appintegrations]` - Type annotations for
  [AppIntegrationsService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appintegrations/)
  service.
- `boto3-stubs[application-autoscaling]` - Type annotations for
  [ApplicationAutoScaling](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_application_autoscaling/)
  service.
- `boto3-stubs[application-insights]` - Type annotations for
  [ApplicationInsights](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_application_insights/)
  service.
- `boto3-stubs[applicationcostprofiler]` - Type annotations for
  [ApplicationCostProfiler](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_applicationcostprofiler/)
  service.
- `boto3-stubs[appmesh]` - Type annotations for
  [AppMesh](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appmesh/)
  service.
- `boto3-stubs[apprunner]` - Type annotations for
  [AppRunner](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_apprunner/)
  service.
- `boto3-stubs[appstream]` - Type annotations for
  [AppStream](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appstream/)
  service.
- `boto3-stubs[appsync]` - Type annotations for
  [AppSync](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appsync/)
  service.
- `boto3-stubs[athena]` - Type annotations for
  [Athena](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_athena/)
  service.
- `boto3-stubs[auditmanager]` - Type annotations for
  [AuditManager](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_auditmanager/)
  service.
- `boto3-stubs[autoscaling]` - Type annotations for
  [AutoScaling](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_autoscaling/)
  service.
- `boto3-stubs[autoscaling-plans]` - Type annotations for
  [AutoScalingPlans](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_autoscaling_plans/)
  service.
- `boto3-stubs[backup]` - Type annotations for
  [Backup](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_backup/)
  service.
- `boto3-stubs[batch]` - Type annotations for
  [Batch](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_batch/) service.
- `boto3-stubs[braket]` - Type annotations for
  [Braket](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_braket/)
  service.
- `boto3-stubs[budgets]` - Type annotations for
  [Budgets](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_budgets/)
  service.
- `boto3-stubs[ce]` - Type annotations for
  [CostExplorer](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ce/)
  service.
- `boto3-stubs[chime]` - Type annotations for
  [Chime](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_chime/) service.
- `boto3-stubs[chime-sdk-identity]` - Type annotations for
  [ChimeSDKIdentity](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_identity/)
  service.
- `boto3-stubs[chime-sdk-messaging]` - Type annotations for
  [ChimeSDKMessaging](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_messaging/)
  service.
- `boto3-stubs[cloud9]` - Type annotations for
  [Cloud9](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloud9/)
  service.
- `boto3-stubs[clouddirectory]` - Type annotations for
  [CloudDirectory](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_clouddirectory/)
  service.
- `boto3-stubs[cloudformation]` - Type annotations for
  [CloudFormation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudformation/)
  service.
- `boto3-stubs[cloudfront]` - Type annotations for
  [CloudFront](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudfront/)
  service.
- `boto3-stubs[cloudhsm]` - Type annotations for
  [CloudHSM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudhsm/)
  service.
- `boto3-stubs[cloudhsmv2]` - Type annotations for
  [CloudHSMV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudhsmv2/)
  service.
- `boto3-stubs[cloudsearch]` - Type annotations for
  [CloudSearch](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudsearch/)
  service.
- `boto3-stubs[cloudsearchdomain]` - Type annotations for
  [CloudSearchDomain](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudsearchdomain/)
  service.
- `boto3-stubs[cloudtrail]` - Type annotations for
  [CloudTrail](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudtrail/)
  service.
- `boto3-stubs[cloudwatch]` - Type annotations for
  [CloudWatch](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudwatch/)
  service.
- `boto3-stubs[codeartifact]` - Type annotations for
  [CodeArtifact](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeartifact/)
  service.
- `boto3-stubs[codebuild]` - Type annotations for
  [CodeBuild](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codebuild/)
  service.
- `boto3-stubs[codecommit]` - Type annotations for
  [CodeCommit](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codecommit/)
  service.
- `boto3-stubs[codedeploy]` - Type annotations for
  [CodeDeploy](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codedeploy/)
  service.
- `boto3-stubs[codeguru-reviewer]` - Type annotations for
  [CodeGuruReviewer](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeguru_reviewer/)
  service.
- `boto3-stubs[codeguruprofiler]` - Type annotations for
  [CodeGuruProfiler](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeguruprofiler/)
  service.
- `boto3-stubs[codepipeline]` - Type annotations for
  [CodePipeline](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codepipeline/)
  service.
- `boto3-stubs[codestar]` - Type annotations for
  [CodeStar](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codestar/)
  service.
- `boto3-stubs[codestar-connections]` - Type annotations for
  [CodeStarconnections](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codestar_connections/)
  service.
- `boto3-stubs[codestar-notifications]` - Type annotations for
  [CodeStarNotifications](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codestar_notifications/)
  service.
- `boto3-stubs[cognito-identity]` - Type annotations for
  [CognitoIdentity](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cognito_identity/)
  service.
- `boto3-stubs[cognito-idp]` - Type annotations for
  [CognitoIdentityProvider](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cognito_idp/)
  service.
- `boto3-stubs[cognito-sync]` - Type annotations for
  [CognitoSync](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cognito_sync/)
  service.
- `boto3-stubs[comprehend]` - Type annotations for
  [Comprehend](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_comprehend/)
  service.
- `boto3-stubs[comprehendmedical]` - Type annotations for
  [ComprehendMedical](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_comprehendmedical/)
  service.
- `boto3-stubs[compute-optimizer]` - Type annotations for
  [ComputeOptimizer](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_compute_optimizer/)
  service.
- `boto3-stubs[config]` - Type annotations for
  [ConfigService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_config/)
  service.
- `boto3-stubs[connect]` - Type annotations for
  [Connect](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_connect/)
  service.
- `boto3-stubs[connect-contact-lens]` - Type annotations for
  [ConnectContactLens](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_connect_contact_lens/)
  service.
- `boto3-stubs[connectparticipant]` - Type annotations for
  [ConnectParticipant](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_connectparticipant/)
  service.
- `boto3-stubs[cur]` - Type annotations for
  [CostandUsageReportService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cur/)
  service.
- `boto3-stubs[customer-profiles]` - Type annotations for
  [CustomerProfiles](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_customer_profiles/)
  service.
- `boto3-stubs[databrew]` - Type annotations for
  [GlueDataBrew](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_databrew/)
  service.
- `boto3-stubs[dataexchange]` - Type annotations for
  [DataExchange](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dataexchange/)
  service.
- `boto3-stubs[datapipeline]` - Type annotations for
  [DataPipeline](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_datapipeline/)
  service.
- `boto3-stubs[datasync]` - Type annotations for
  [DataSync](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_datasync/)
  service.
- `boto3-stubs[dax]` - Type annotations for
  [DAX](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dax/) service.
- `boto3-stubs[detective]` - Type annotations for
  [Detective](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_detective/)
  service.
- `boto3-stubs[devicefarm]` - Type annotations for
  [DeviceFarm](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_devicefarm/)
  service.
- `boto3-stubs[devops-guru]` - Type annotations for
  [DevOpsGuru](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_devops_guru/)
  service.
- `boto3-stubs[directconnect]` - Type annotations for
  [DirectConnect](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_directconnect/)
  service.
- `boto3-stubs[discovery]` - Type annotations for
  [ApplicationDiscoveryService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_discovery/)
  service.
- `boto3-stubs[dlm]` - Type annotations for
  [DLM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dlm/) service.
- `boto3-stubs[dms]` - Type annotations for
  [DatabaseMigrationService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dms/)
  service.
- `boto3-stubs[docdb]` - Type annotations for
  [DocDB](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_docdb/) service.
- `boto3-stubs[ds]` - Type annotations for
  [DirectoryService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ds/)
  service.
- `boto3-stubs[dynamodb]` - Type annotations for
  [DynamoDB](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/)
  service.
- `boto3-stubs[dynamodbstreams]` - Type annotations for
  [DynamoDBStreams](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_dynamodbstreams/)
  service.
- `boto3-stubs[ebs]` - Type annotations for
  [EBS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ebs/) service.
- `boto3-stubs[ec2]` - Type annotations for
  [EC2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ec2/) service.
- `boto3-stubs[ec2-instance-connect]` - Type annotations for
  [EC2InstanceConnect](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ec2_instance_connect/)
  service.
- `boto3-stubs[ecr]` - Type annotations for
  [ECR](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecr/) service.
- `boto3-stubs[ecr-public]` - Type annotations for
  [ECRPublic](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecr_public/)
  service.
- `boto3-stubs[ecs]` - Type annotations for
  [ECS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecs/) service.
- `boto3-stubs[efs]` - Type annotations for
  [EFS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_efs/) service.
- `boto3-stubs[eks]` - Type annotations for
  [EKS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_eks/) service.
- `boto3-stubs[elastic-inference]` - Type annotations for
  [ElasticInference](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elastic_inference/)
  service.
- `boto3-stubs[elasticache]` - Type annotations for
  [ElastiCache](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elasticache/)
  service.
- `boto3-stubs[elasticbeanstalk]` - Type annotations for
  [ElasticBeanstalk](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elasticbeanstalk/)
  service.
- `boto3-stubs[elastictranscoder]` - Type annotations for
  [ElasticTranscoder](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elastictranscoder/)
  service.
- `boto3-stubs[elb]` - Type annotations for
  [ElasticLoadBalancing](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elb/)
  service.
- `boto3-stubs[elbv2]` - Type annotations for
  [ElasticLoadBalancingv2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elbv2/)
  service.
- `boto3-stubs[emr]` - Type annotations for
  [EMR](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_emr/) service.
- `boto3-stubs[emr-containers]` - Type annotations for
  [EMRContainers](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_emr_containers/)
  service.
- `boto3-stubs[es]` - Type annotations for
  [ElasticsearchService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_es/)
  service.
- `boto3-stubs[events]` - Type annotations for
  [EventBridge](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_events/)
  service.
- `boto3-stubs[finspace]` - Type annotations for
  [finspace](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_finspace/)
  service.
- `boto3-stubs[finspace-data]` - Type annotations for
  [FinSpaceData](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_finspace_data/)
  service.
- `boto3-stubs[firehose]` - Type annotations for
  [Firehose](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_firehose/)
  service.
- `boto3-stubs[fis]` - Type annotations for
  [FIS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_fis/) service.
- `boto3-stubs[fms]` - Type annotations for
  [FMS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_fms/) service.
- `boto3-stubs[forecast]` - Type annotations for
  [ForecastService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_forecast/)
  service.
- `boto3-stubs[forecastquery]` - Type annotations for
  [ForecastQueryService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_forecastquery/)
  service.
- `boto3-stubs[frauddetector]` - Type annotations for
  [FraudDetector](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_frauddetector/)
  service.
- `boto3-stubs[fsx]` - Type annotations for
  [FSx](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_fsx/) service.
- `boto3-stubs[gamelift]` - Type annotations for
  [GameLift](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_gamelift/)
  service.
- `boto3-stubs[glacier]` - Type annotations for
  [Glacier](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_glacier/)
  service.
- `boto3-stubs[globalaccelerator]` - Type annotations for
  [GlobalAccelerator](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_globalaccelerator/)
  service.
- `boto3-stubs[glue]` - Type annotations for
  [Glue](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_glue/) service.
- `boto3-stubs[greengrass]` - Type annotations for
  [Greengrass](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_greengrass/)
  service.
- `boto3-stubs[greengrassv2]` - Type annotations for
  [GreengrassV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_greengrassv2/)
  service.
- `boto3-stubs[groundstation]` - Type annotations for
  [GroundStation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_groundstation/)
  service.
- `boto3-stubs[guardduty]` - Type annotations for
  [GuardDuty](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_guardduty/)
  service.
- `boto3-stubs[health]` - Type annotations for
  [Health](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_health/)
  service.
- `boto3-stubs[healthlake]` - Type annotations for
  [HealthLake](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_healthlake/)
  service.
- `boto3-stubs[honeycode]` - Type annotations for
  [Honeycode](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_honeycode/)
  service.
- `boto3-stubs[iam]` - Type annotations for
  [IAM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iam/) service.
- `boto3-stubs[identitystore]` - Type annotations for
  [IdentityStore](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_identitystore/)
  service.
- `boto3-stubs[imagebuilder]` - Type annotations for
  [imagebuilder](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_imagebuilder/)
  service.
- `boto3-stubs[importexport]` - Type annotations for
  [ImportExport](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_importexport/)
  service.
- `boto3-stubs[inspector]` - Type annotations for
  [Inspector](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_inspector/)
  service.
- `boto3-stubs[iot]` - Type annotations for
  [IoT](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iot/) service.
- `boto3-stubs[iot-data]` - Type annotations for
  [IoTDataPlane](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iot_data/)
  service.
- `boto3-stubs[iot-jobs-data]` - Type annotations for
  [IoTJobsDataPlane](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iot_jobs_data/)
  service.
- `boto3-stubs[iot1click-devices]` - Type annotations for
  [IoT1ClickDevicesService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iot1click_devices/)
  service.
- `boto3-stubs[iot1click-projects]` - Type annotations for
  [IoT1ClickProjects](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iot1click_projects/)
  service.
- `boto3-stubs[iotanalytics]` - Type annotations for
  [IoTAnalytics](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotanalytics/)
  service.
- `boto3-stubs[iotdeviceadvisor]` - Type annotations for
  [IoTDeviceAdvisor](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotdeviceadvisor/)
  service.
- `boto3-stubs[iotevents]` - Type annotations for
  [IoTEvents](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotevents/)
  service.
- `boto3-stubs[iotevents-data]` - Type annotations for
  [IoTEventsData](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotevents_data/)
  service.
- `boto3-stubs[iotfleethub]` - Type annotations for
  [IoTFleetHub](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotfleethub/)
  service.
- `boto3-stubs[iotsecuretunneling]` - Type annotations for
  [IoTSecureTunneling](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotsecuretunneling/)
  service.
- `boto3-stubs[iotsitewise]` - Type annotations for
  [IoTSiteWise](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotsitewise/)
  service.
- `boto3-stubs[iotthingsgraph]` - Type annotations for
  [IoTThingsGraph](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotthingsgraph/)
  service.
- `boto3-stubs[iotwireless]` - Type annotations for
  [IoTWireless](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotwireless/)
  service.
- `boto3-stubs[ivs]` - Type annotations for
  [IVS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ivs/) service.
- `boto3-stubs[kafka]` - Type annotations for
  [Kafka](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kafka/) service.
- `boto3-stubs[kafkaconnect]` - Type annotations for
  [KafkaConnect](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kafkaconnect/)
  service.
- `boto3-stubs[kendra]` - Type annotations for
  [kendra](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kendra/)
  service.
- `boto3-stubs[kinesis]` - Type annotations for
  [Kinesis](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesis/)
  service.
- `boto3-stubs[kinesis-video-archived-media]` - Type annotations for
  [KinesisVideoArchivedMedia](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_archived_media/)
  service.
- `boto3-stubs[kinesis-video-media]` - Type annotations for
  [KinesisVideoMedia](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_media/)
  service.
- `boto3-stubs[kinesis-video-signaling]` - Type annotations for
  [KinesisVideoSignalingChannels](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_signaling/)
  service.
- `boto3-stubs[kinesisanalytics]` - Type annotations for
  [KinesisAnalytics](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisanalytics/)
  service.
- `boto3-stubs[kinesisanalyticsv2]` - Type annotations for
  [KinesisAnalyticsV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisanalyticsv2/)
  service.
- `boto3-stubs[kinesisvideo]` - Type annotations for
  [KinesisVideo](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kinesisvideo/)
  service.
- `boto3-stubs[kms]` - Type annotations for
  [KMS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kms/) service.
- `boto3-stubs[lakeformation]` - Type annotations for
  [LakeFormation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lakeformation/)
  service.
- `boto3-stubs[lambda]` - Type annotations for
  [Lambda](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lambda/)
  service.
- `boto3-stubs[lex-models]` - Type annotations for
  [LexModelBuildingService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lex_models/)
  service.
- `boto3-stubs[lex-runtime]` - Type annotations for
  [LexRuntimeService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lex_runtime/)
  service.
- `boto3-stubs[lexv2-models]` - Type annotations for
  [LexModelsV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lexv2_models/)
  service.
- `boto3-stubs[lexv2-runtime]` - Type annotations for
  [LexRuntimeV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lexv2_runtime/)
  service.
- `boto3-stubs[license-manager]` - Type annotations for
  [LicenseManager](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_license_manager/)
  service.
- `boto3-stubs[lightsail]` - Type annotations for
  [Lightsail](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lightsail/)
  service.
- `boto3-stubs[location]` - Type annotations for
  [LocationService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_location/)
  service.
- `boto3-stubs[logs]` - Type annotations for
  [CloudWatchLogs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_logs/)
  service.
- `boto3-stubs[lookoutequipment]` - Type annotations for
  [LookoutEquipment](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lookoutequipment/)
  service.
- `boto3-stubs[lookoutmetrics]` - Type annotations for
  [LookoutMetrics](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lookoutmetrics/)
  service.
- `boto3-stubs[lookoutvision]` - Type annotations for
  [LookoutforVision](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lookoutvision/)
  service.
- `boto3-stubs[machinelearning]` - Type annotations for
  [MachineLearning](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_machinelearning/)
  service.
- `boto3-stubs[macie]` - Type annotations for
  [Macie](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_macie/) service.
- `boto3-stubs[macie2]` - Type annotations for
  [Macie2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_macie2/)
  service.
- `boto3-stubs[managedblockchain]` - Type annotations for
  [ManagedBlockchain](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_managedblockchain/)
  service.
- `boto3-stubs[marketplace-catalog]` - Type annotations for
  [MarketplaceCatalog](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_marketplace_catalog/)
  service.
- `boto3-stubs[marketplace-entitlement]` - Type annotations for
  [MarketplaceEntitlementService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_marketplace_entitlement/)
  service.
- `boto3-stubs[marketplacecommerceanalytics]` - Type annotations for
  [MarketplaceCommerceAnalytics](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_marketplacecommerceanalytics/)
  service.
- `boto3-stubs[mediaconnect]` - Type annotations for
  [MediaConnect](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediaconnect/)
  service.
- `boto3-stubs[mediaconvert]` - Type annotations for
  [MediaConvert](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediaconvert/)
  service.
- `boto3-stubs[medialive]` - Type annotations for
  [MediaLive](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_medialive/)
  service.
- `boto3-stubs[mediapackage]` - Type annotations for
  [MediaPackage](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediapackage/)
  service.
- `boto3-stubs[mediapackage-vod]` - Type annotations for
  [MediaPackageVod](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediapackage_vod/)
  service.
- `boto3-stubs[mediastore]` - Type annotations for
  [MediaStore](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediastore/)
  service.
- `boto3-stubs[mediastore-data]` - Type annotations for
  [MediaStoreData](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediastore_data/)
  service.
- `boto3-stubs[mediatailor]` - Type annotations for
  [MediaTailor](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediatailor/)
  service.
- `boto3-stubs[memorydb]` - Type annotations for
  [MemoryDB](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_memorydb/)
  service.
- `boto3-stubs[meteringmarketplace]` - Type annotations for
  [MarketplaceMetering](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_meteringmarketplace/)
  service.
- `boto3-stubs[mgh]` - Type annotations for
  [MigrationHub](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mgh/)
  service.
- `boto3-stubs[mgn]` - Type annotations for
  [mgn](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mgn/) service.
- `boto3-stubs[migrationhub-config]` - Type annotations for
  [MigrationHubConfig](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_migrationhub_config/)
  service.
- `boto3-stubs[mobile]` - Type annotations for
  [Mobile](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mobile/)
  service.
- `boto3-stubs[mq]` - Type annotations for
  [MQ](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mq/) service.
- `boto3-stubs[mturk]` - Type annotations for
  [MTurk](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mturk/) service.
- `boto3-stubs[mwaa]` - Type annotations for
  [MWAA](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mwaa/) service.
- `boto3-stubs[neptune]` - Type annotations for
  [Neptune](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_neptune/)
  service.
- `boto3-stubs[network-firewall]` - Type annotations for
  [NetworkFirewall](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_network_firewall/)
  service.
- `boto3-stubs[networkmanager]` - Type annotations for
  [NetworkManager](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_networkmanager/)
  service.
- `boto3-stubs[nimble]` - Type annotations for
  [NimbleStudio](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_nimble/)
  service.
- `boto3-stubs[opensearch]` - Type annotations for
  [OpenSearchService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opensearch/)
  service.
- `boto3-stubs[opsworks]` - Type annotations for
  [OpsWorks](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opsworks/)
  service.
- `boto3-stubs[opsworkscm]` - Type annotations for
  [OpsWorksCM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opsworkscm/)
  service.
- `boto3-stubs[organizations]` - Type annotations for
  [Organizations](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_organizations/)
  service.
- `boto3-stubs[outposts]` - Type annotations for
  [Outposts](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_outposts/)
  service.
- `boto3-stubs[personalize]` - Type annotations for
  [Personalize](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_personalize/)
  service.
- `boto3-stubs[personalize-events]` - Type annotations for
  [PersonalizeEvents](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_personalize_events/)
  service.
- `boto3-stubs[personalize-runtime]` - Type annotations for
  [PersonalizeRuntime](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_personalize_runtime/)
  service.
- `boto3-stubs[pi]` - Type annotations for
  [PI](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pi/) service.
- `boto3-stubs[pinpoint]` - Type annotations for
  [Pinpoint](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint/)
  service.
- `boto3-stubs[pinpoint-email]` - Type annotations for
  [PinpointEmail](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_email/)
  service.
- `boto3-stubs[pinpoint-sms-voice]` - Type annotations for
  [PinpointSMSVoice](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_sms_voice/)
  service.
- `boto3-stubs[polly]` - Type annotations for
  [Polly](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_polly/) service.
- `boto3-stubs[pricing]` - Type annotations for
  [Pricing](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_pricing/)
  service.
- `boto3-stubs[proton]` - Type annotations for
  [Proton](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_proton/)
  service.
- `boto3-stubs[qldb]` - Type annotations for
  [QLDB](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_qldb/) service.
- `boto3-stubs[qldb-session]` - Type annotations for
  [QLDBSession](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_qldb_session/)
  service.
- `boto3-stubs[quicksight]` - Type annotations for
  [QuickSight](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_quicksight/)
  service.
- `boto3-stubs[ram]` - Type annotations for
  [RAM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ram/) service.
- `boto3-stubs[rds]` - Type annotations for
  [RDS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rds/) service.
- `boto3-stubs[rds-data]` - Type annotations for
  [RDSDataService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rds_data/)
  service.
- `boto3-stubs[redshift]` - Type annotations for
  [Redshift](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_redshift/)
  service.
- `boto3-stubs[redshift-data]` - Type annotations for
  [RedshiftDataAPIService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_redshift_data/)
  service.
- `boto3-stubs[rekognition]` - Type annotations for
  [Rekognition](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rekognition/)
  service.
- `boto3-stubs[resource-groups]` - Type annotations for
  [ResourceGroups](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_resource_groups/)
  service.
- `boto3-stubs[resourcegroupstaggingapi]` - Type annotations for
  [ResourceGroupsTaggingAPI](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_resourcegroupstaggingapi/)
  service.
- `boto3-stubs[robomaker]` - Type annotations for
  [RoboMaker](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_robomaker/)
  service.
- `boto3-stubs[route53]` - Type annotations for
  [Route53](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53/)
  service.
- `boto3-stubs[route53-recovery-cluster]` - Type annotations for
  [Route53RecoveryCluster](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53_recovery_cluster/)
  service.
- `boto3-stubs[route53-recovery-control-config]` - Type annotations for
  [Route53RecoveryControlConfig](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53_recovery_control_config/)
  service.
- `boto3-stubs[route53-recovery-readiness]` - Type annotations for
  [Route53RecoveryReadiness](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53_recovery_readiness/)
  service.
- `boto3-stubs[route53domains]` - Type annotations for
  [Route53Domains](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53domains/)
  service.
- `boto3-stubs[route53resolver]` - Type annotations for
  [Route53Resolver](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53resolver/)
  service.
- `boto3-stubs[s3]` - Type annotations for
  [S3](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3/) service.
- `boto3-stubs[s3control]` - Type annotations for
  [S3Control](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3control/)
  service.
- `boto3-stubs[s3outposts]` - Type annotations for
  [S3Outposts](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_s3outposts/)
  service.
- `boto3-stubs[sagemaker]` - Type annotations for
  [SageMaker](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker/)
  service.
- `boto3-stubs[sagemaker-a2i-runtime]` - Type annotations for
  [AugmentedAIRuntime](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_a2i_runtime/)
  service.
- `boto3-stubs[sagemaker-edge]` - Type annotations for
  [SagemakerEdgeManager](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_edge/)
  service.
- `boto3-stubs[sagemaker-featurestore-runtime]` - Type annotations for
  [SageMakerFeatureStoreRuntime](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_featurestore_runtime/)
  service.
- `boto3-stubs[sagemaker-runtime]` - Type annotations for
  [SageMakerRuntime](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_runtime/)
  service.
- `boto3-stubs[savingsplans]` - Type annotations for
  [SavingsPlans](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_savingsplans/)
  service.
- `boto3-stubs[schemas]` - Type annotations for
  [Schemas](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_schemas/)
  service.
- `boto3-stubs[sdb]` - Type annotations for
  [SimpleDB](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sdb/) service.
- `boto3-stubs[secretsmanager]` - Type annotations for
  [SecretsManager](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_secretsmanager/)
  service.
- `boto3-stubs[securityhub]` - Type annotations for
  [SecurityHub](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_securityhub/)
  service.
- `boto3-stubs[serverlessrepo]` - Type annotations for
  [ServerlessApplicationRepository](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_serverlessrepo/)
  service.
- `boto3-stubs[service-quotas]` - Type annotations for
  [ServiceQuotas](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_service_quotas/)
  service.
- `boto3-stubs[servicecatalog]` - Type annotations for
  [ServiceCatalog](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_servicecatalog/)
  service.
- `boto3-stubs[servicecatalog-appregistry]` - Type annotations for
  [AppRegistry](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_servicecatalog_appregistry/)
  service.
- `boto3-stubs[servicediscovery]` - Type annotations for
  [ServiceDiscovery](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_servicediscovery/)
  service.
- `boto3-stubs[ses]` - Type annotations for
  [SES](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ses/) service.
- `boto3-stubs[sesv2]` - Type annotations for
  [SESV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sesv2/) service.
- `boto3-stubs[shield]` - Type annotations for
  [Shield](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_shield/)
  service.
- `boto3-stubs[signer]` - Type annotations for
  [signer](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_signer/)
  service.
- `boto3-stubs[sms]` - Type annotations for
  [SMS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sms/) service.
- `boto3-stubs[sms-voice]` - Type annotations for
  [PinpointSMSVoice](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sms_voice/)
  service.
- `boto3-stubs[snow-device-management]` - Type annotations for
  [SnowDeviceManagement](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_snow_device_management/)
  service.
- `boto3-stubs[snowball]` - Type annotations for
  [Snowball](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_snowball/)
  service.
- `boto3-stubs[sns]` - Type annotations for
  [SNS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sns/) service.
- `boto3-stubs[sqs]` - Type annotations for
  [SQS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sqs/) service.
- `boto3-stubs[ssm]` - Type annotations for
  [SSM](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm/) service.
- `boto3-stubs[ssm-contacts]` - Type annotations for
  [SSMContacts](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm_contacts/)
  service.
- `boto3-stubs[ssm-incidents]` - Type annotations for
  [SSMIncidents](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ssm_incidents/)
  service.
- `boto3-stubs[sso]` - Type annotations for
  [SSO](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso/) service.
- `boto3-stubs[sso-admin]` - Type annotations for
  [SSOAdmin](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso_admin/)
  service.
- `boto3-stubs[sso-oidc]` - Type annotations for
  [SSOOIDC](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso_oidc/)
  service.
- `boto3-stubs[stepfunctions]` - Type annotations for
  [SFN](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_stepfunctions/)
  service.
- `boto3-stubs[storagegateway]` - Type annotations for
  [StorageGateway](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_storagegateway/)
  service.
- `boto3-stubs[sts]` - Type annotations for
  [STS](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sts/) service.
- `boto3-stubs[support]` - Type annotations for
  [Support](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_support/)
  service.
- `boto3-stubs[swf]` - Type annotations for
  [SWF](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_swf/) service.
- `boto3-stubs[synthetics]` - Type annotations for
  [Synthetics](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_synthetics/)
  service.
- `boto3-stubs[textract]` - Type annotations for
  [Textract](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_textract/)
  service.
- `boto3-stubs[timestream-query]` - Type annotations for
  [TimestreamQuery](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_timestream_query/)
  service.
- `boto3-stubs[timestream-write]` - Type annotations for
  [TimestreamWrite](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_timestream_write/)
  service.
- `boto3-stubs[transcribe]` - Type annotations for
  [TranscribeService](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_transcribe/)
  service.
- `boto3-stubs[transfer]` - Type annotations for
  [Transfer](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_transfer/)
  service.
- `boto3-stubs[translate]` - Type annotations for
  [Translate](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_translate/)
  service.
- `boto3-stubs[waf]` - Type annotations for
  [WAF](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_waf/) service.
- `boto3-stubs[waf-regional]` - Type annotations for
  [WAFRegional](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_waf_regional/)
  service.
- `boto3-stubs[wafv2]` - Type annotations for
  [WAFV2](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_wafv2/) service.
- `boto3-stubs[wellarchitected]` - Type annotations for
  [WellArchitected](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_wellarchitected/)
  service.
- `boto3-stubs[workdocs]` - Type annotations for
  [WorkDocs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workdocs/)
  service.
- `boto3-stubs[worklink]` - Type annotations for
  [WorkLink](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_worklink/)
  service.
- `boto3-stubs[workmail]` - Type annotations for
  [WorkMail](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workmail/)
  service.
- `boto3-stubs[workmailmessageflow]` - Type annotations for
  [WorkMailMessageFlow](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workmailmessageflow/)
  service.
- `boto3-stubs[workspaces]` - Type annotations for
  [WorkSpaces](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workspaces/)
  service.
- `boto3-stubs[xray]` - Type annotations for
  [XRay](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_xray/) service.
  <a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3-stubs docs](https://vemel.github.io/boto3_stubs_docs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
