from os.path import abspath, dirname

from setuptools import setup

LONG_DESCRIPTION = open(dirname(abspath(__file__)) + "/README.md", "r").read()


setup(
    name="boto3-stubs",
    version="1.18.47",
    packages=["boto3-stubs"],
    url="https://github.com/vemel/mypy_boto3_builder",
    license="MIT License",
    author="Vlad Emelianov",
    author_email="vlad.emelianov.nz@gmail.com",
    description="Type annotations for boto3 1.18.47, generated by mypy-boto3-builder 5.3.1",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Environment :: Console",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: Implementation :: CPython",
        "Typing :: Typed",
    ],
    keywords="boto3 type-annotations boto3-stubs mypy typeshed autocomplete",
    long_description=LONG_DESCRIPTION,
    long_description_content_type="text/markdown",
    package_data={"boto3-stubs": ["py.typed", "*.pyi", "*/*.pyi"]},
    python_requires=">=3.6",
    project_urls={
        "Documentation": "https://mypy-boto3-builder.readthedocs.io/en/latest/",
        "Source": "https://github.com/vemel/mypy_boto3_builder",
        "Tracker": "https://github.com/vemel/mypy_boto3_builder/issues",
    },
    install_requires=[
        "botocore-stubs",
        "typing_extensions; python_version < '3.8'",
    ],
    extras_require={
        "all": [
            "mypy-boto3-accessanalyzer>=1.18.42",
            "mypy-boto3-acm>=1.18.42",
            "mypy-boto3-acm-pca>=1.18.42",
            "mypy-boto3-alexaforbusiness>=1.18.42",
            "mypy-boto3-amp>=1.18.42",
            "mypy-boto3-amplify>=1.18.42",
            "mypy-boto3-amplifybackend>=1.18.42",
            "mypy-boto3-apigateway>=1.18.42",
            "mypy-boto3-apigatewaymanagementapi>=1.18.42",
            "mypy-boto3-apigatewayv2>=1.18.42",
            "mypy-boto3-appconfig>=1.18.42",
            "mypy-boto3-appflow>=1.18.42",
            "mypy-boto3-appintegrations>=1.18.42",
            "mypy-boto3-application-autoscaling>=1.18.42",
            "mypy-boto3-application-insights>=1.18.42",
            "mypy-boto3-applicationcostprofiler>=1.18.42",
            "mypy-boto3-appmesh>=1.18.42",
            "mypy-boto3-apprunner>=1.18.42",
            "mypy-boto3-appstream>=1.18.42",
            "mypy-boto3-appsync>=1.18.42",
            "mypy-boto3-athena>=1.18.42",
            "mypy-boto3-auditmanager>=1.18.42",
            "mypy-boto3-autoscaling>=1.18.42",
            "mypy-boto3-autoscaling-plans>=1.18.42",
            "mypy-boto3-backup>=1.18.42",
            "mypy-boto3-batch>=1.18.42",
            "mypy-boto3-braket>=1.18.42",
            "mypy-boto3-budgets>=1.18.42",
            "mypy-boto3-ce>=1.18.42",
            "mypy-boto3-chime>=1.18.42",
            "mypy-boto3-chime-sdk-identity>=1.18.42",
            "mypy-boto3-chime-sdk-messaging>=1.18.42",
            "mypy-boto3-cloud9>=1.18.42",
            "mypy-boto3-clouddirectory>=1.18.42",
            "mypy-boto3-cloudformation>=1.18.42",
            "mypy-boto3-cloudfront>=1.18.42",
            "mypy-boto3-cloudhsm>=1.18.42",
            "mypy-boto3-cloudhsmv2>=1.18.42",
            "mypy-boto3-cloudsearch>=1.18.42",
            "mypy-boto3-cloudsearchdomain>=1.18.42",
            "mypy-boto3-cloudtrail>=1.18.42",
            "mypy-boto3-cloudwatch>=1.18.42",
            "mypy-boto3-codeartifact>=1.18.42",
            "mypy-boto3-codebuild>=1.18.42",
            "mypy-boto3-codecommit>=1.18.42",
            "mypy-boto3-codedeploy>=1.18.42",
            "mypy-boto3-codeguru-reviewer>=1.18.42",
            "mypy-boto3-codeguruprofiler>=1.18.42",
            "mypy-boto3-codepipeline>=1.18.42",
            "mypy-boto3-codestar>=1.18.42",
            "mypy-boto3-codestar-connections>=1.18.42",
            "mypy-boto3-codestar-notifications>=1.18.42",
            "mypy-boto3-cognito-identity>=1.18.42",
            "mypy-boto3-cognito-idp>=1.18.42",
            "mypy-boto3-cognito-sync>=1.18.42",
            "mypy-boto3-comprehend>=1.18.42",
            "mypy-boto3-comprehendmedical>=1.18.42",
            "mypy-boto3-compute-optimizer>=1.18.42",
            "mypy-boto3-config>=1.18.42",
            "mypy-boto3-connect>=1.18.42",
            "mypy-boto3-connect-contact-lens>=1.18.42",
            "mypy-boto3-connectparticipant>=1.18.42",
            "mypy-boto3-cur>=1.18.42",
            "mypy-boto3-customer-profiles>=1.18.42",
            "mypy-boto3-databrew>=1.18.42",
            "mypy-boto3-dataexchange>=1.18.42",
            "mypy-boto3-datapipeline>=1.18.42",
            "mypy-boto3-datasync>=1.18.42",
            "mypy-boto3-dax>=1.18.42",
            "mypy-boto3-detective>=1.18.42",
            "mypy-boto3-devicefarm>=1.18.42",
            "mypy-boto3-devops-guru>=1.18.42",
            "mypy-boto3-directconnect>=1.18.42",
            "mypy-boto3-discovery>=1.18.42",
            "mypy-boto3-dlm>=1.18.42",
            "mypy-boto3-dms>=1.18.42",
            "mypy-boto3-docdb>=1.18.42",
            "mypy-boto3-ds>=1.18.42",
            "mypy-boto3-dynamodb>=1.18.42",
            "mypy-boto3-dynamodbstreams>=1.18.42",
            "mypy-boto3-ebs>=1.18.42",
            "mypy-boto3-ec2>=1.18.42",
            "mypy-boto3-ec2-instance-connect>=1.18.42",
            "mypy-boto3-ecr>=1.18.42",
            "mypy-boto3-ecr-public>=1.18.42",
            "mypy-boto3-ecs>=1.18.42",
            "mypy-boto3-efs>=1.18.42",
            "mypy-boto3-eks>=1.18.42",
            "mypy-boto3-elastic-inference>=1.18.42",
            "mypy-boto3-elasticache>=1.18.42",
            "mypy-boto3-elasticbeanstalk>=1.18.42",
            "mypy-boto3-elastictranscoder>=1.18.42",
            "mypy-boto3-elb>=1.18.42",
            "mypy-boto3-elbv2>=1.18.42",
            "mypy-boto3-emr>=1.18.42",
            "mypy-boto3-emr-containers>=1.18.42",
            "mypy-boto3-es>=1.18.42",
            "mypy-boto3-events>=1.18.42",
            "mypy-boto3-finspace>=1.18.42",
            "mypy-boto3-finspace-data>=1.18.42",
            "mypy-boto3-firehose>=1.18.42",
            "mypy-boto3-fis>=1.18.42",
            "mypy-boto3-fms>=1.18.42",
            "mypy-boto3-forecast>=1.18.42",
            "mypy-boto3-forecastquery>=1.18.42",
            "mypy-boto3-frauddetector>=1.18.42",
            "mypy-boto3-fsx>=1.18.42",
            "mypy-boto3-gamelift>=1.18.42",
            "mypy-boto3-glacier>=1.18.42",
            "mypy-boto3-globalaccelerator>=1.18.42",
            "mypy-boto3-glue>=1.18.42",
            "mypy-boto3-greengrass>=1.18.42",
            "mypy-boto3-greengrassv2>=1.18.42",
            "mypy-boto3-groundstation>=1.18.42",
            "mypy-boto3-guardduty>=1.18.42",
            "mypy-boto3-health>=1.18.42",
            "mypy-boto3-healthlake>=1.18.42",
            "mypy-boto3-honeycode>=1.18.42",
            "mypy-boto3-iam>=1.18.42",
            "mypy-boto3-identitystore>=1.18.42",
            "mypy-boto3-imagebuilder>=1.18.42",
            "mypy-boto3-importexport>=1.18.42",
            "mypy-boto3-inspector>=1.18.42",
            "mypy-boto3-iot>=1.18.42",
            "mypy-boto3-iot-data>=1.18.42",
            "mypy-boto3-iot-jobs-data>=1.18.42",
            "mypy-boto3-iot1click-devices>=1.18.42",
            "mypy-boto3-iot1click-projects>=1.18.42",
            "mypy-boto3-iotanalytics>=1.18.42",
            "mypy-boto3-iotdeviceadvisor>=1.18.42",
            "mypy-boto3-iotevents>=1.18.42",
            "mypy-boto3-iotevents-data>=1.18.42",
            "mypy-boto3-iotfleethub>=1.18.42",
            "mypy-boto3-iotsecuretunneling>=1.18.42",
            "mypy-boto3-iotsitewise>=1.18.42",
            "mypy-boto3-iotthingsgraph>=1.18.42",
            "mypy-boto3-iotwireless>=1.18.42",
            "mypy-boto3-ivs>=1.18.42",
            "mypy-boto3-kafka>=1.18.42",
            "mypy-boto3-kafkaconnect>=1.18.42",
            "mypy-boto3-kendra>=1.18.42",
            "mypy-boto3-kinesis>=1.18.42",
            "mypy-boto3-kinesis-video-archived-media>=1.18.42",
            "mypy-boto3-kinesis-video-media>=1.18.42",
            "mypy-boto3-kinesis-video-signaling>=1.18.42",
            "mypy-boto3-kinesisanalytics>=1.18.42",
            "mypy-boto3-kinesisanalyticsv2>=1.18.42",
            "mypy-boto3-kinesisvideo>=1.18.42",
            "mypy-boto3-kms>=1.18.42",
            "mypy-boto3-lakeformation>=1.18.42",
            "mypy-boto3-lambda>=1.18.42",
            "mypy-boto3-lex-models>=1.18.42",
            "mypy-boto3-lex-runtime>=1.18.42",
            "mypy-boto3-lexv2-models>=1.18.42",
            "mypy-boto3-lexv2-runtime>=1.18.42",
            "mypy-boto3-license-manager>=1.18.42",
            "mypy-boto3-lightsail>=1.18.42",
            "mypy-boto3-location>=1.18.42",
            "mypy-boto3-logs>=1.18.42",
            "mypy-boto3-lookoutequipment>=1.18.42",
            "mypy-boto3-lookoutmetrics>=1.18.42",
            "mypy-boto3-lookoutvision>=1.18.42",
            "mypy-boto3-machinelearning>=1.18.42",
            "mypy-boto3-macie>=1.18.42",
            "mypy-boto3-macie2>=1.18.42",
            "mypy-boto3-managedblockchain>=1.18.42",
            "mypy-boto3-marketplace-catalog>=1.18.42",
            "mypy-boto3-marketplace-entitlement>=1.18.42",
            "mypy-boto3-marketplacecommerceanalytics>=1.18.42",
            "mypy-boto3-mediaconnect>=1.18.42",
            "mypy-boto3-mediaconvert>=1.18.42",
            "mypy-boto3-medialive>=1.18.42",
            "mypy-boto3-mediapackage>=1.18.42",
            "mypy-boto3-mediapackage-vod>=1.18.42",
            "mypy-boto3-mediastore>=1.18.42",
            "mypy-boto3-mediastore-data>=1.18.42",
            "mypy-boto3-mediatailor>=1.18.42",
            "mypy-boto3-memorydb>=1.18.42",
            "mypy-boto3-meteringmarketplace>=1.18.42",
            "mypy-boto3-mgh>=1.18.42",
            "mypy-boto3-mgn>=1.18.42",
            "mypy-boto3-migrationhub-config>=1.18.42",
            "mypy-boto3-mobile>=1.18.42",
            "mypy-boto3-mq>=1.18.42",
            "mypy-boto3-mturk>=1.18.42",
            "mypy-boto3-mwaa>=1.18.42",
            "mypy-boto3-neptune>=1.18.42",
            "mypy-boto3-network-firewall>=1.18.42",
            "mypy-boto3-networkmanager>=1.18.42",
            "mypy-boto3-nimble>=1.18.42",
            "mypy-boto3-opensearch>=1.18.42",
            "mypy-boto3-opsworks>=1.18.42",
            "mypy-boto3-opsworkscm>=1.18.42",
            "mypy-boto3-organizations>=1.18.42",
            "mypy-boto3-outposts>=1.18.42",
            "mypy-boto3-personalize>=1.18.42",
            "mypy-boto3-personalize-events>=1.18.42",
            "mypy-boto3-personalize-runtime>=1.18.42",
            "mypy-boto3-pi>=1.18.42",
            "mypy-boto3-pinpoint>=1.18.42",
            "mypy-boto3-pinpoint-email>=1.18.42",
            "mypy-boto3-pinpoint-sms-voice>=1.18.42",
            "mypy-boto3-polly>=1.18.42",
            "mypy-boto3-pricing>=1.18.42",
            "mypy-boto3-proton>=1.18.42",
            "mypy-boto3-qldb>=1.18.42",
            "mypy-boto3-qldb-session>=1.18.42",
            "mypy-boto3-quicksight>=1.18.42",
            "mypy-boto3-ram>=1.18.42",
            "mypy-boto3-rds>=1.18.42",
            "mypy-boto3-rds-data>=1.18.42",
            "mypy-boto3-redshift>=1.18.42",
            "mypy-boto3-redshift-data>=1.18.42",
            "mypy-boto3-rekognition>=1.18.42",
            "mypy-boto3-resource-groups>=1.18.42",
            "mypy-boto3-resourcegroupstaggingapi>=1.18.42",
            "mypy-boto3-robomaker>=1.18.42",
            "mypy-boto3-route53>=1.18.42",
            "mypy-boto3-route53-recovery-cluster>=1.18.42",
            "mypy-boto3-route53-recovery-control-config>=1.18.42",
            "mypy-boto3-route53-recovery-readiness>=1.18.42",
            "mypy-boto3-route53domains>=1.18.42",
            "mypy-boto3-route53resolver>=1.18.42",
            "mypy-boto3-s3>=1.18.42",
            "mypy-boto3-s3control>=1.18.42",
            "mypy-boto3-s3outposts>=1.18.42",
            "mypy-boto3-sagemaker>=1.18.42",
            "mypy-boto3-sagemaker-a2i-runtime>=1.18.42",
            "mypy-boto3-sagemaker-edge>=1.18.42",
            "mypy-boto3-sagemaker-featurestore-runtime>=1.18.42",
            "mypy-boto3-sagemaker-runtime>=1.18.42",
            "mypy-boto3-savingsplans>=1.18.42",
            "mypy-boto3-schemas>=1.18.42",
            "mypy-boto3-sdb>=1.18.42",
            "mypy-boto3-secretsmanager>=1.18.42",
            "mypy-boto3-securityhub>=1.18.42",
            "mypy-boto3-serverlessrepo>=1.18.42",
            "mypy-boto3-service-quotas>=1.18.42",
            "mypy-boto3-servicecatalog>=1.18.42",
            "mypy-boto3-servicecatalog-appregistry>=1.18.42",
            "mypy-boto3-servicediscovery>=1.18.42",
            "mypy-boto3-ses>=1.18.42",
            "mypy-boto3-sesv2>=1.18.42",
            "mypy-boto3-shield>=1.18.42",
            "mypy-boto3-signer>=1.18.42",
            "mypy-boto3-sms>=1.18.42",
            "mypy-boto3-sms-voice>=1.18.42",
            "mypy-boto3-snow-device-management>=1.18.42",
            "mypy-boto3-snowball>=1.18.42",
            "mypy-boto3-sns>=1.18.42",
            "mypy-boto3-sqs>=1.18.42",
            "mypy-boto3-ssm>=1.18.42",
            "mypy-boto3-ssm-contacts>=1.18.42",
            "mypy-boto3-ssm-incidents>=1.18.42",
            "mypy-boto3-sso>=1.18.42",
            "mypy-boto3-sso-admin>=1.18.42",
            "mypy-boto3-sso-oidc>=1.18.42",
            "mypy-boto3-stepfunctions>=1.18.42",
            "mypy-boto3-storagegateway>=1.18.42",
            "mypy-boto3-sts>=1.18.42",
            "mypy-boto3-support>=1.18.42",
            "mypy-boto3-swf>=1.18.42",
            "mypy-boto3-synthetics>=1.18.42",
            "mypy-boto3-textract>=1.18.42",
            "mypy-boto3-timestream-query>=1.18.42",
            "mypy-boto3-timestream-write>=1.18.42",
            "mypy-boto3-transcribe>=1.18.42",
            "mypy-boto3-transfer>=1.18.42",
            "mypy-boto3-translate>=1.18.42",
            "mypy-boto3-waf>=1.18.42",
            "mypy-boto3-waf-regional>=1.18.42",
            "mypy-boto3-wafv2>=1.18.42",
            "mypy-boto3-wellarchitected>=1.18.42",
            "mypy-boto3-workdocs>=1.18.42",
            "mypy-boto3-worklink>=1.18.42",
            "mypy-boto3-workmail>=1.18.42",
            "mypy-boto3-workmailmessageflow>=1.18.42",
            "mypy-boto3-workspaces>=1.18.42",
            "mypy-boto3-xray>=1.18.42",
        ],
        "essential": [
            "mypy-boto3-cloudformation>=1.18.42",
            "mypy-boto3-dynamodb>=1.18.42",
            "mypy-boto3-ec2>=1.18.42",
            "mypy-boto3-lambda>=1.18.42",
            "mypy-boto3-rds>=1.18.42",
            "mypy-boto3-s3>=1.18.42",
            "mypy-boto3-sqs>=1.18.42",
        ],
        "accessanalyzer": ["mypy-boto3-accessanalyzer>=1.18.42"],
        "acm": ["mypy-boto3-acm>=1.18.42"],
        "acm-pca": ["mypy-boto3-acm-pca>=1.18.42"],
        "alexaforbusiness": ["mypy-boto3-alexaforbusiness>=1.18.42"],
        "amp": ["mypy-boto3-amp>=1.18.42"],
        "amplify": ["mypy-boto3-amplify>=1.18.42"],
        "amplifybackend": ["mypy-boto3-amplifybackend>=1.18.42"],
        "apigateway": ["mypy-boto3-apigateway>=1.18.42"],
        "apigatewaymanagementapi": ["mypy-boto3-apigatewaymanagementapi>=1.18.42"],
        "apigatewayv2": ["mypy-boto3-apigatewayv2>=1.18.42"],
        "appconfig": ["mypy-boto3-appconfig>=1.18.42"],
        "appflow": ["mypy-boto3-appflow>=1.18.42"],
        "appintegrations": ["mypy-boto3-appintegrations>=1.18.42"],
        "application-autoscaling": ["mypy-boto3-application-autoscaling>=1.18.42"],
        "application-insights": ["mypy-boto3-application-insights>=1.18.42"],
        "applicationcostprofiler": ["mypy-boto3-applicationcostprofiler>=1.18.42"],
        "appmesh": ["mypy-boto3-appmesh>=1.18.42"],
        "apprunner": ["mypy-boto3-apprunner>=1.18.42"],
        "appstream": ["mypy-boto3-appstream>=1.18.42"],
        "appsync": ["mypy-boto3-appsync>=1.18.42"],
        "athena": ["mypy-boto3-athena>=1.18.42"],
        "auditmanager": ["mypy-boto3-auditmanager>=1.18.42"],
        "autoscaling": ["mypy-boto3-autoscaling>=1.18.42"],
        "autoscaling-plans": ["mypy-boto3-autoscaling-plans>=1.18.42"],
        "backup": ["mypy-boto3-backup>=1.18.42"],
        "batch": ["mypy-boto3-batch>=1.18.42"],
        "braket": ["mypy-boto3-braket>=1.18.42"],
        "budgets": ["mypy-boto3-budgets>=1.18.42"],
        "ce": ["mypy-boto3-ce>=1.18.42"],
        "chime": ["mypy-boto3-chime>=1.18.42"],
        "chime-sdk-identity": ["mypy-boto3-chime-sdk-identity>=1.18.42"],
        "chime-sdk-messaging": ["mypy-boto3-chime-sdk-messaging>=1.18.42"],
        "cloud9": ["mypy-boto3-cloud9>=1.18.42"],
        "clouddirectory": ["mypy-boto3-clouddirectory>=1.18.42"],
        "cloudformation": ["mypy-boto3-cloudformation>=1.18.42"],
        "cloudfront": ["mypy-boto3-cloudfront>=1.18.42"],
        "cloudhsm": ["mypy-boto3-cloudhsm>=1.18.42"],
        "cloudhsmv2": ["mypy-boto3-cloudhsmv2>=1.18.42"],
        "cloudsearch": ["mypy-boto3-cloudsearch>=1.18.42"],
        "cloudsearchdomain": ["mypy-boto3-cloudsearchdomain>=1.18.42"],
        "cloudtrail": ["mypy-boto3-cloudtrail>=1.18.42"],
        "cloudwatch": ["mypy-boto3-cloudwatch>=1.18.42"],
        "codeartifact": ["mypy-boto3-codeartifact>=1.18.42"],
        "codebuild": ["mypy-boto3-codebuild>=1.18.42"],
        "codecommit": ["mypy-boto3-codecommit>=1.18.42"],
        "codedeploy": ["mypy-boto3-codedeploy>=1.18.42"],
        "codeguru-reviewer": ["mypy-boto3-codeguru-reviewer>=1.18.42"],
        "codeguruprofiler": ["mypy-boto3-codeguruprofiler>=1.18.42"],
        "codepipeline": ["mypy-boto3-codepipeline>=1.18.42"],
        "codestar": ["mypy-boto3-codestar>=1.18.42"],
        "codestar-connections": ["mypy-boto3-codestar-connections>=1.18.42"],
        "codestar-notifications": ["mypy-boto3-codestar-notifications>=1.18.42"],
        "cognito-identity": ["mypy-boto3-cognito-identity>=1.18.42"],
        "cognito-idp": ["mypy-boto3-cognito-idp>=1.18.42"],
        "cognito-sync": ["mypy-boto3-cognito-sync>=1.18.42"],
        "comprehend": ["mypy-boto3-comprehend>=1.18.42"],
        "comprehendmedical": ["mypy-boto3-comprehendmedical>=1.18.42"],
        "compute-optimizer": ["mypy-boto3-compute-optimizer>=1.18.42"],
        "config": ["mypy-boto3-config>=1.18.42"],
        "connect": ["mypy-boto3-connect>=1.18.42"],
        "connect-contact-lens": ["mypy-boto3-connect-contact-lens>=1.18.42"],
        "connectparticipant": ["mypy-boto3-connectparticipant>=1.18.42"],
        "cur": ["mypy-boto3-cur>=1.18.42"],
        "customer-profiles": ["mypy-boto3-customer-profiles>=1.18.42"],
        "databrew": ["mypy-boto3-databrew>=1.18.42"],
        "dataexchange": ["mypy-boto3-dataexchange>=1.18.42"],
        "datapipeline": ["mypy-boto3-datapipeline>=1.18.42"],
        "datasync": ["mypy-boto3-datasync>=1.18.42"],
        "dax": ["mypy-boto3-dax>=1.18.42"],
        "detective": ["mypy-boto3-detective>=1.18.42"],
        "devicefarm": ["mypy-boto3-devicefarm>=1.18.42"],
        "devops-guru": ["mypy-boto3-devops-guru>=1.18.42"],
        "directconnect": ["mypy-boto3-directconnect>=1.18.42"],
        "discovery": ["mypy-boto3-discovery>=1.18.42"],
        "dlm": ["mypy-boto3-dlm>=1.18.42"],
        "dms": ["mypy-boto3-dms>=1.18.42"],
        "docdb": ["mypy-boto3-docdb>=1.18.42"],
        "ds": ["mypy-boto3-ds>=1.18.42"],
        "dynamodb": ["mypy-boto3-dynamodb>=1.18.42"],
        "dynamodbstreams": ["mypy-boto3-dynamodbstreams>=1.18.42"],
        "ebs": ["mypy-boto3-ebs>=1.18.42"],
        "ec2": ["mypy-boto3-ec2>=1.18.42"],
        "ec2-instance-connect": ["mypy-boto3-ec2-instance-connect>=1.18.42"],
        "ecr": ["mypy-boto3-ecr>=1.18.42"],
        "ecr-public": ["mypy-boto3-ecr-public>=1.18.42"],
        "ecs": ["mypy-boto3-ecs>=1.18.42"],
        "efs": ["mypy-boto3-efs>=1.18.42"],
        "eks": ["mypy-boto3-eks>=1.18.42"],
        "elastic-inference": ["mypy-boto3-elastic-inference>=1.18.42"],
        "elasticache": ["mypy-boto3-elasticache>=1.18.42"],
        "elasticbeanstalk": ["mypy-boto3-elasticbeanstalk>=1.18.42"],
        "elastictranscoder": ["mypy-boto3-elastictranscoder>=1.18.42"],
        "elb": ["mypy-boto3-elb>=1.18.42"],
        "elbv2": ["mypy-boto3-elbv2>=1.18.42"],
        "emr": ["mypy-boto3-emr>=1.18.42"],
        "emr-containers": ["mypy-boto3-emr-containers>=1.18.42"],
        "es": ["mypy-boto3-es>=1.18.42"],
        "events": ["mypy-boto3-events>=1.18.42"],
        "finspace": ["mypy-boto3-finspace>=1.18.42"],
        "finspace-data": ["mypy-boto3-finspace-data>=1.18.42"],
        "firehose": ["mypy-boto3-firehose>=1.18.42"],
        "fis": ["mypy-boto3-fis>=1.18.42"],
        "fms": ["mypy-boto3-fms>=1.18.42"],
        "forecast": ["mypy-boto3-forecast>=1.18.42"],
        "forecastquery": ["mypy-boto3-forecastquery>=1.18.42"],
        "frauddetector": ["mypy-boto3-frauddetector>=1.18.42"],
        "fsx": ["mypy-boto3-fsx>=1.18.42"],
        "gamelift": ["mypy-boto3-gamelift>=1.18.42"],
        "glacier": ["mypy-boto3-glacier>=1.18.42"],
        "globalaccelerator": ["mypy-boto3-globalaccelerator>=1.18.42"],
        "glue": ["mypy-boto3-glue>=1.18.42"],
        "greengrass": ["mypy-boto3-greengrass>=1.18.42"],
        "greengrassv2": ["mypy-boto3-greengrassv2>=1.18.42"],
        "groundstation": ["mypy-boto3-groundstation>=1.18.42"],
        "guardduty": ["mypy-boto3-guardduty>=1.18.42"],
        "health": ["mypy-boto3-health>=1.18.42"],
        "healthlake": ["mypy-boto3-healthlake>=1.18.42"],
        "honeycode": ["mypy-boto3-honeycode>=1.18.42"],
        "iam": ["mypy-boto3-iam>=1.18.42"],
        "identitystore": ["mypy-boto3-identitystore>=1.18.42"],
        "imagebuilder": ["mypy-boto3-imagebuilder>=1.18.42"],
        "importexport": ["mypy-boto3-importexport>=1.18.42"],
        "inspector": ["mypy-boto3-inspector>=1.18.42"],
        "iot": ["mypy-boto3-iot>=1.18.42"],
        "iot-data": ["mypy-boto3-iot-data>=1.18.42"],
        "iot-jobs-data": ["mypy-boto3-iot-jobs-data>=1.18.42"],
        "iot1click-devices": ["mypy-boto3-iot1click-devices>=1.18.42"],
        "iot1click-projects": ["mypy-boto3-iot1click-projects>=1.18.42"],
        "iotanalytics": ["mypy-boto3-iotanalytics>=1.18.42"],
        "iotdeviceadvisor": ["mypy-boto3-iotdeviceadvisor>=1.18.42"],
        "iotevents": ["mypy-boto3-iotevents>=1.18.42"],
        "iotevents-data": ["mypy-boto3-iotevents-data>=1.18.42"],
        "iotfleethub": ["mypy-boto3-iotfleethub>=1.18.42"],
        "iotsecuretunneling": ["mypy-boto3-iotsecuretunneling>=1.18.42"],
        "iotsitewise": ["mypy-boto3-iotsitewise>=1.18.42"],
        "iotthingsgraph": ["mypy-boto3-iotthingsgraph>=1.18.42"],
        "iotwireless": ["mypy-boto3-iotwireless>=1.18.42"],
        "ivs": ["mypy-boto3-ivs>=1.18.42"],
        "kafka": ["mypy-boto3-kafka>=1.18.42"],
        "kafkaconnect": ["mypy-boto3-kafkaconnect>=1.18.42"],
        "kendra": ["mypy-boto3-kendra>=1.18.42"],
        "kinesis": ["mypy-boto3-kinesis>=1.18.42"],
        "kinesis-video-archived-media": ["mypy-boto3-kinesis-video-archived-media>=1.18.42"],
        "kinesis-video-media": ["mypy-boto3-kinesis-video-media>=1.18.42"],
        "kinesis-video-signaling": ["mypy-boto3-kinesis-video-signaling>=1.18.42"],
        "kinesisanalytics": ["mypy-boto3-kinesisanalytics>=1.18.42"],
        "kinesisanalyticsv2": ["mypy-boto3-kinesisanalyticsv2>=1.18.42"],
        "kinesisvideo": ["mypy-boto3-kinesisvideo>=1.18.42"],
        "kms": ["mypy-boto3-kms>=1.18.42"],
        "lakeformation": ["mypy-boto3-lakeformation>=1.18.42"],
        "lambda": ["mypy-boto3-lambda>=1.18.42"],
        "lex-models": ["mypy-boto3-lex-models>=1.18.42"],
        "lex-runtime": ["mypy-boto3-lex-runtime>=1.18.42"],
        "lexv2-models": ["mypy-boto3-lexv2-models>=1.18.42"],
        "lexv2-runtime": ["mypy-boto3-lexv2-runtime>=1.18.42"],
        "license-manager": ["mypy-boto3-license-manager>=1.18.42"],
        "lightsail": ["mypy-boto3-lightsail>=1.18.42"],
        "location": ["mypy-boto3-location>=1.18.42"],
        "logs": ["mypy-boto3-logs>=1.18.42"],
        "lookoutequipment": ["mypy-boto3-lookoutequipment>=1.18.42"],
        "lookoutmetrics": ["mypy-boto3-lookoutmetrics>=1.18.42"],
        "lookoutvision": ["mypy-boto3-lookoutvision>=1.18.42"],
        "machinelearning": ["mypy-boto3-machinelearning>=1.18.42"],
        "macie": ["mypy-boto3-macie>=1.18.42"],
        "macie2": ["mypy-boto3-macie2>=1.18.42"],
        "managedblockchain": ["mypy-boto3-managedblockchain>=1.18.42"],
        "marketplace-catalog": ["mypy-boto3-marketplace-catalog>=1.18.42"],
        "marketplace-entitlement": ["mypy-boto3-marketplace-entitlement>=1.18.42"],
        "marketplacecommerceanalytics": ["mypy-boto3-marketplacecommerceanalytics>=1.18.42"],
        "mediaconnect": ["mypy-boto3-mediaconnect>=1.18.42"],
        "mediaconvert": ["mypy-boto3-mediaconvert>=1.18.42"],
        "medialive": ["mypy-boto3-medialive>=1.18.42"],
        "mediapackage": ["mypy-boto3-mediapackage>=1.18.42"],
        "mediapackage-vod": ["mypy-boto3-mediapackage-vod>=1.18.42"],
        "mediastore": ["mypy-boto3-mediastore>=1.18.42"],
        "mediastore-data": ["mypy-boto3-mediastore-data>=1.18.42"],
        "mediatailor": ["mypy-boto3-mediatailor>=1.18.42"],
        "memorydb": ["mypy-boto3-memorydb>=1.18.42"],
        "meteringmarketplace": ["mypy-boto3-meteringmarketplace>=1.18.42"],
        "mgh": ["mypy-boto3-mgh>=1.18.42"],
        "mgn": ["mypy-boto3-mgn>=1.18.42"],
        "migrationhub-config": ["mypy-boto3-migrationhub-config>=1.18.42"],
        "mobile": ["mypy-boto3-mobile>=1.18.42"],
        "mq": ["mypy-boto3-mq>=1.18.42"],
        "mturk": ["mypy-boto3-mturk>=1.18.42"],
        "mwaa": ["mypy-boto3-mwaa>=1.18.42"],
        "neptune": ["mypy-boto3-neptune>=1.18.42"],
        "network-firewall": ["mypy-boto3-network-firewall>=1.18.42"],
        "networkmanager": ["mypy-boto3-networkmanager>=1.18.42"],
        "nimble": ["mypy-boto3-nimble>=1.18.42"],
        "opensearch": ["mypy-boto3-opensearch>=1.18.42"],
        "opsworks": ["mypy-boto3-opsworks>=1.18.42"],
        "opsworkscm": ["mypy-boto3-opsworkscm>=1.18.42"],
        "organizations": ["mypy-boto3-organizations>=1.18.42"],
        "outposts": ["mypy-boto3-outposts>=1.18.42"],
        "personalize": ["mypy-boto3-personalize>=1.18.42"],
        "personalize-events": ["mypy-boto3-personalize-events>=1.18.42"],
        "personalize-runtime": ["mypy-boto3-personalize-runtime>=1.18.42"],
        "pi": ["mypy-boto3-pi>=1.18.42"],
        "pinpoint": ["mypy-boto3-pinpoint>=1.18.42"],
        "pinpoint-email": ["mypy-boto3-pinpoint-email>=1.18.42"],
        "pinpoint-sms-voice": ["mypy-boto3-pinpoint-sms-voice>=1.18.42"],
        "polly": ["mypy-boto3-polly>=1.18.42"],
        "pricing": ["mypy-boto3-pricing>=1.18.42"],
        "proton": ["mypy-boto3-proton>=1.18.42"],
        "qldb": ["mypy-boto3-qldb>=1.18.42"],
        "qldb-session": ["mypy-boto3-qldb-session>=1.18.42"],
        "quicksight": ["mypy-boto3-quicksight>=1.18.42"],
        "ram": ["mypy-boto3-ram>=1.18.42"],
        "rds": ["mypy-boto3-rds>=1.18.42"],
        "rds-data": ["mypy-boto3-rds-data>=1.18.42"],
        "redshift": ["mypy-boto3-redshift>=1.18.42"],
        "redshift-data": ["mypy-boto3-redshift-data>=1.18.42"],
        "rekognition": ["mypy-boto3-rekognition>=1.18.42"],
        "resource-groups": ["mypy-boto3-resource-groups>=1.18.42"],
        "resourcegroupstaggingapi": ["mypy-boto3-resourcegroupstaggingapi>=1.18.42"],
        "robomaker": ["mypy-boto3-robomaker>=1.18.42"],
        "route53": ["mypy-boto3-route53>=1.18.42"],
        "route53-recovery-cluster": ["mypy-boto3-route53-recovery-cluster>=1.18.42"],
        "route53-recovery-control-config": ["mypy-boto3-route53-recovery-control-config>=1.18.42"],
        "route53-recovery-readiness": ["mypy-boto3-route53-recovery-readiness>=1.18.42"],
        "route53domains": ["mypy-boto3-route53domains>=1.18.42"],
        "route53resolver": ["mypy-boto3-route53resolver>=1.18.42"],
        "s3": ["mypy-boto3-s3>=1.18.42"],
        "s3control": ["mypy-boto3-s3control>=1.18.42"],
        "s3outposts": ["mypy-boto3-s3outposts>=1.18.42"],
        "sagemaker": ["mypy-boto3-sagemaker>=1.18.42"],
        "sagemaker-a2i-runtime": ["mypy-boto3-sagemaker-a2i-runtime>=1.18.42"],
        "sagemaker-edge": ["mypy-boto3-sagemaker-edge>=1.18.42"],
        "sagemaker-featurestore-runtime": ["mypy-boto3-sagemaker-featurestore-runtime>=1.18.42"],
        "sagemaker-runtime": ["mypy-boto3-sagemaker-runtime>=1.18.42"],
        "savingsplans": ["mypy-boto3-savingsplans>=1.18.42"],
        "schemas": ["mypy-boto3-schemas>=1.18.42"],
        "sdb": ["mypy-boto3-sdb>=1.18.42"],
        "secretsmanager": ["mypy-boto3-secretsmanager>=1.18.42"],
        "securityhub": ["mypy-boto3-securityhub>=1.18.42"],
        "serverlessrepo": ["mypy-boto3-serverlessrepo>=1.18.42"],
        "service-quotas": ["mypy-boto3-service-quotas>=1.18.42"],
        "servicecatalog": ["mypy-boto3-servicecatalog>=1.18.42"],
        "servicecatalog-appregistry": ["mypy-boto3-servicecatalog-appregistry>=1.18.42"],
        "servicediscovery": ["mypy-boto3-servicediscovery>=1.18.42"],
        "ses": ["mypy-boto3-ses>=1.18.42"],
        "sesv2": ["mypy-boto3-sesv2>=1.18.42"],
        "shield": ["mypy-boto3-shield>=1.18.42"],
        "signer": ["mypy-boto3-signer>=1.18.42"],
        "sms": ["mypy-boto3-sms>=1.18.42"],
        "sms-voice": ["mypy-boto3-sms-voice>=1.18.42"],
        "snow-device-management": ["mypy-boto3-snow-device-management>=1.18.42"],
        "snowball": ["mypy-boto3-snowball>=1.18.42"],
        "sns": ["mypy-boto3-sns>=1.18.42"],
        "sqs": ["mypy-boto3-sqs>=1.18.42"],
        "ssm": ["mypy-boto3-ssm>=1.18.42"],
        "ssm-contacts": ["mypy-boto3-ssm-contacts>=1.18.42"],
        "ssm-incidents": ["mypy-boto3-ssm-incidents>=1.18.42"],
        "sso": ["mypy-boto3-sso>=1.18.42"],
        "sso-admin": ["mypy-boto3-sso-admin>=1.18.42"],
        "sso-oidc": ["mypy-boto3-sso-oidc>=1.18.42"],
        "stepfunctions": ["mypy-boto3-stepfunctions>=1.18.42"],
        "storagegateway": ["mypy-boto3-storagegateway>=1.18.42"],
        "sts": ["mypy-boto3-sts>=1.18.42"],
        "support": ["mypy-boto3-support>=1.18.42"],
        "swf": ["mypy-boto3-swf>=1.18.42"],
        "synthetics": ["mypy-boto3-synthetics>=1.18.42"],
        "textract": ["mypy-boto3-textract>=1.18.42"],
        "timestream-query": ["mypy-boto3-timestream-query>=1.18.42"],
        "timestream-write": ["mypy-boto3-timestream-write>=1.18.42"],
        "transcribe": ["mypy-boto3-transcribe>=1.18.42"],
        "transfer": ["mypy-boto3-transfer>=1.18.42"],
        "translate": ["mypy-boto3-translate>=1.18.42"],
        "waf": ["mypy-boto3-waf>=1.18.42"],
        "waf-regional": ["mypy-boto3-waf-regional>=1.18.42"],
        "wafv2": ["mypy-boto3-wafv2>=1.18.42"],
        "wellarchitected": ["mypy-boto3-wellarchitected>=1.18.42"],
        "workdocs": ["mypy-boto3-workdocs>=1.18.42"],
        "worklink": ["mypy-boto3-worklink>=1.18.42"],
        "workmail": ["mypy-boto3-workmail>=1.18.42"],
        "workmailmessageflow": ["mypy-boto3-workmailmessageflow>=1.18.42"],
        "workspaces": ["mypy-boto3-workspaces>=1.18.42"],
        "xray": ["mypy-boto3-xray>=1.18.42"],
    },
    zip_safe=False,
)
