# generated by datamodel-codegen:
#   filename:  .openapi.json
#   timestamp: 2025-09-12T16:54:34+00:00

from __future__ import annotations
from typing import Annotated, Any, Dict, List, Optional, Union
from pydantic import AwareDatetime, BaseModel, ConfigDict, Field, RootModel
from enum import Enum


class TraceAndSpanId(RootModel[List]):
    root: Annotated[List, Field(max_length=2, min_length=2)]


class EvalResultsFetch(BaseModel):
    experiment_run_id: Annotated[str, Field(title="Experiment Run Id")]
    project_name: Annotated[str, Field(title="Project Name")]


class DatasetFetch(BaseModel):
    dataset_name: Annotated[str, Field(title="Dataset Name")]
    project_name: Annotated[str, Field(title="Project Name")]


class DatasetsFetch(BaseModel):
    project_name: Annotated[str, Field(title="Project Name")]


class ProjectAdd(BaseModel):
    project_name: Annotated[str, Field(title="Project Name")]


class ProjectAddResponse(BaseModel):
    project_id: Annotated[str, Field(title="Project Id")]


class ProjectDeleteFromJudgevalResponse(BaseModel):
    project_name: Annotated[str, Field(title="Project Name")]


class ProjectDeleteResponse(BaseModel):
    message: Annotated[str, Field(title="Message")]


class ScorerExistsRequest(BaseModel):
    name: Annotated[str, Field(title="Name")]


class ScorerExistsResponse(BaseModel):
    exists: Annotated[bool, Field(title="Exists")]


class SavePromptScorerRequest(BaseModel):
    name: Annotated[str, Field(title="Name")]
    prompt: Annotated[str, Field(title="Prompt")]
    threshold: Annotated[float, Field(title="Threshold")]
    options: Annotated[Optional[Dict[str, float]], Field(title="Options")] = None
    is_trace: Annotated[Optional[bool], Field(title="Is Trace")] = None


class SavePromptScorerResponse(BaseModel):
    message: Annotated[str, Field(title="Message")]
    name: Annotated[str, Field(title="Name")]


class FetchPromptScorersRequest(BaseModel):
    names: Annotated[Optional[List[str]], Field(title="Names")] = None


class CustomScorerUploadPayload(BaseModel):
    scorer_name: Annotated[str, Field(title="Scorer Name")]
    scorer_code: Annotated[str, Field(title="Scorer Code")]
    requirements_text: Annotated[str, Field(title="Requirements Text")]


class CustomScorerTemplateResponse(BaseModel):
    scorer_name: Annotated[str, Field(title="Scorer Name")]
    status: Annotated[str, Field(title="Status")]
    message: Annotated[str, Field(title="Message")]


class ResolveProjectNameRequest(BaseModel):
    project_name: Annotated[str, Field(title="Project Name")]


class ResolveProjectNameResponse(BaseModel):
    project_id: Annotated[str, Field(title="Project Id")]


class TraceIdRequest(BaseModel):
    trace_id: Annotated[str, Field(title="Trace Id")]


class SpanScoreRequest(BaseModel):
    span_id: Annotated[str, Field(title="Span Id")]
    trace_id: Annotated[str, Field(title="Trace Id")]


class BaseScorer(BaseModel):
    score_type: Annotated[str, Field(title="Score Type")]
    threshold: Annotated[Optional[float], Field(title="Threshold")] = 0.5
    name: Annotated[Optional[str], Field(title="Name")] = None
    class_name: Annotated[Optional[str], Field(title="Class Name")] = None
    score: Annotated[Optional[float], Field(title="Score")] = None
    score_breakdown: Annotated[
        Optional[Dict[str, Any]], Field(title="Score Breakdown")
    ] = None
    reason: Annotated[Optional[str], Field(title="Reason")] = ""
    using_native_model: Annotated[Optional[bool], Field(title="Using Native Model")] = (
        None
    )
    success: Annotated[Optional[bool], Field(title="Success")] = None
    model: Annotated[Optional[str], Field(title="Model")] = None
    model_client: Annotated[Any, Field(title="Model Client")] = None
    strict_mode: Annotated[Optional[bool], Field(title="Strict Mode")] = False
    error: Annotated[Optional[str], Field(title="Error")] = None
    additional_metadata: Annotated[
        Optional[Dict[str, Any]], Field(title="Additional Metadata")
    ] = None
    user: Annotated[Optional[str], Field(title="User")] = None
    server_hosted: Annotated[Optional[bool], Field(title="Server Hosted")] = False


class ScorerConfig(BaseModel):
    score_type: Annotated[str, Field(title="Score Type")]
    name: Annotated[Optional[str], Field(title="Name")] = None
    threshold: Annotated[Optional[float], Field(title="Threshold")] = 0.5
    strict_mode: Annotated[Optional[bool], Field(title="Strict Mode")] = False
    required_params: Annotated[Optional[List[str]], Field(title="Required Params")] = []
    kwargs: Annotated[Optional[Dict[str, Any]], Field(title="Kwargs")] = None


class Example(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    example_id: Annotated[Optional[str], Field(title="Example Id")] = None
    created_at: Annotated[Optional[str], Field(title="Created At")] = None
    name: Annotated[Optional[str], Field(title="Name")] = None


class ValidationError(BaseModel):
    loc: Annotated[List[Union[str, int]], Field(title="Location")]
    msg: Annotated[str, Field(title="Message")]
    type: Annotated[str, Field(title="Error Type")]


class DatasetKind(Enum):
    trace = "trace"
    example = "example"


class PromptScorer(BaseModel):
    name: Annotated[str, Field(title="Name")]
    prompt: Annotated[str, Field(title="Prompt")]
    threshold: Annotated[float, Field(title="Threshold")]
    options: Annotated[Optional[Dict[str, float]], Field(title="Options")] = None
    created_at: Annotated[Optional[AwareDatetime], Field(title="Created At")] = None
    updated_at: Annotated[Optional[AwareDatetime], Field(title="Updated At")] = None
    is_trace: Annotated[Optional[bool], Field(title="Is Trace")] = False


class ScorerData(BaseModel):
    id: Annotated[Optional[str], Field(title="Id")] = None
    name: Annotated[str, Field(title="Name")]
    threshold: Annotated[float, Field(title="Threshold")]
    success: Annotated[bool, Field(title="Success")]
    score: Annotated[Optional[float], Field(title="Score")] = None
    reason: Annotated[Optional[str], Field(title="Reason")] = None
    strict_mode: Annotated[Optional[bool], Field(title="Strict Mode")] = None
    evaluation_model: Annotated[Optional[str], Field(title="Evaluation Model")] = None
    error: Annotated[Optional[str], Field(title="Error")] = None
    additional_metadata: Annotated[
        Optional[Dict[str, Any]], Field(title="Additional Metadata")
    ] = None


class OtelTraceSpan(BaseModel):
    organization_id: Annotated[str, Field(title="Organization Id")]
    project_id: Annotated[Optional[str], Field(title="Project Id")] = None
    user_id: Annotated[str, Field(title="User Id")]
    timestamp: Annotated[str, Field(title="Timestamp")]
    trace_id: Annotated[str, Field(title="Trace Id")]
    span_id: Annotated[str, Field(title="Span Id")]
    parent_span_id: Annotated[Optional[str], Field(title="Parent Span Id")] = None
    trace_state: Annotated[Optional[str], Field(title="Trace State")] = None
    span_name: Annotated[Optional[str], Field(title="Span Name")] = None
    span_kind: Annotated[Optional[str], Field(title="Span Kind")] = None
    service_name: Annotated[Optional[str], Field(title="Service Name")] = None
    resource_attributes: Annotated[
        Optional[Dict[str, Any]], Field(title="Resource Attributes")
    ] = None
    span_attributes: Annotated[
        Optional[Dict[str, Any]], Field(title="Span Attributes")
    ] = None
    duration: Annotated[Optional[int], Field(title="Duration")] = None
    status_code: Annotated[Optional[str], Field(title="Status Code")] = None
    status_message: Annotated[Optional[str], Field(title="Status Message")] = None
    events: Annotated[Optional[List[Dict[str, Any]]], Field(title="Events")] = None
    links: Annotated[Optional[List[Dict[str, Any]]], Field(title="Links")] = None
    legacy_span_id: Annotated[Optional[str], Field(title="Legacy Span Id")] = None
    inputs: Annotated[Optional[Dict[str, Any]], Field(title="Inputs")] = None
    output: Annotated[Any, Field(title="Output")]
    error: Annotated[Optional[Dict[str, Any]], Field(title="Error")] = None
    agent_id: Annotated[Optional[str], Field(title="Agent Id")] = None
    cumulative_llm_cost: Annotated[
        Optional[float], Field(title="Cumulative Llm Cost")
    ] = None
    state_after: Annotated[Optional[Dict[str, Any]], Field(title="State After")] = None
    state_before: Annotated[Optional[Dict[str, Any]], Field(title="State Before")] = (
        None
    )


class ExampleEvaluationRun(BaseModel):
    id: Annotated[Optional[str], Field(title="Id")] = None
    project_name: Annotated[str, Field(title="Project Name")]
    eval_name: Annotated[str, Field(title="Eval Name")]
    custom_scorers: Annotated[
        Optional[List[BaseScorer]], Field(title="Custom Scorers")
    ] = []
    judgment_scorers: Annotated[
        Optional[List[ScorerConfig]], Field(title="Judgment Scorers")
    ] = []
    model: Annotated[str, Field(title="Model")]
    created_at: Annotated[Optional[str], Field(title="Created At")] = None
    examples: Annotated[List[Example], Field(title="Examples")]
    trace_span_id: Annotated[Optional[str], Field(title="Trace Span Id")] = None
    trace_id: Annotated[Optional[str], Field(title="Trace Id")] = None


class HTTPValidationError(BaseModel):
    detail: Annotated[Optional[List[ValidationError]], Field(title="Detail")] = None


class TraceEvaluationRun(BaseModel):
    id: Annotated[Optional[str], Field(title="Id")] = None
    project_name: Annotated[str, Field(title="Project Name")]
    eval_name: Annotated[str, Field(title="Eval Name")]
    custom_scorers: Annotated[
        Optional[List[BaseScorer]], Field(title="Custom Scorers")
    ] = []
    judgment_scorers: Annotated[
        Optional[List[ScorerConfig]], Field(title="Judgment Scorers")
    ] = []
    model: Annotated[str, Field(title="Model")]
    created_at: Annotated[Optional[str], Field(title="Created At")] = None
    trace_and_span_ids: Annotated[
        List[TraceAndSpanId], Field(title="Trace And Span Ids")
    ]
    is_offline: Annotated[Optional[bool], Field(title="Is Offline")] = False


class DatasetInsertExamples(BaseModel):
    dataset_name: Annotated[str, Field(title="Dataset Name")]
    examples: Annotated[List[Example], Field(title="Examples")]
    project_name: Annotated[str, Field(title="Project Name")]


class DatasetReturn(BaseModel):
    name: Annotated[str, Field(title="Name")]
    project_name: Annotated[str, Field(title="Project Name")]
    examples: Annotated[Optional[List[Example]], Field(title="Examples")] = None


class DatasetInfo(BaseModel):
    dataset_id: Annotated[str, Field(title="Dataset Id")]
    name: Annotated[str, Field(title="Name")]
    created_at: Annotated[str, Field(title="Created At")]
    dataset_kind: DatasetKind
    entries: Annotated[int, Field(title="Entries")]
    creator: Annotated[str, Field(title="Creator")]


class DatasetCreate(BaseModel):
    name: Annotated[str, Field(title="Name")]
    dataset_kind: DatasetKind
    project_name: Annotated[str, Field(title="Project Name")]
    examples: Annotated[List[Example], Field(title="Examples")]
    overwrite: Annotated[bool, Field(title="Overwrite")]


class FetchPromptScorersResponse(BaseModel):
    scorers: Annotated[List[PromptScorer], Field(title="Scorers")]


class ScoringResult(BaseModel):
    success: Annotated[bool, Field(title="Success")]
    scorers_data: Annotated[List[ScorerData], Field(title="Scorers Data")]
    name: Annotated[Optional[str], Field(title="Name")] = None
    data_object: Annotated[
        Optional[Union[OtelTraceSpan, Example]], Field(title="Data Object")
    ] = None
    trace_id: Annotated[Optional[str], Field(title="Trace Id")] = None
    run_duration: Annotated[Optional[float], Field(title="Run Duration")] = None
    evaluation_cost: Annotated[Optional[float], Field(title="Evaluation Cost")] = None


class EvalResults(BaseModel):
    results: Annotated[List[ScoringResult], Field(title="Results")]
    run: Annotated[Union[ExampleEvaluationRun, TraceEvaluationRun], Field(title="Run")]
