from abc import ABC, abstractmethod

class BaseModel(ABC):
    def __init__(self):
        pass
    
    @abstractmethod
    def get_response(self, input_data: str) -> str:
        """
        Abstract method to get a response from the model.
        
        Args:
            input_data (str): The input data for the model.
        
        Returns:
            str: The response generated by the model.
        """
        pass