import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IFileSystem } from './efs-file-system';
/**
 * (experimental) Represents an EFS AccessPoint.
 *
 * @experimental
 */
export interface IAccessPoint extends IResource {
    /**
     * (experimental) The ID of the AccessPoint.
     *
     * @experimental
     * @attribute true
     */
    readonly accessPointId: string;
    /**
     * (experimental) The ARN of the AccessPoint.
     *
     * @experimental
     * @attribute true
     */
    readonly accessPointArn: string;
    /**
     * (experimental) The EFS file system.
     *
     * @experimental
     */
    readonly fileSystem: IFileSystem;
}
/**
 * (experimental) Permissions as POSIX ACL.
 *
 * @experimental
 */
export interface Acl {
    /**
     * (experimental) Specifies the POSIX user ID to apply to the RootDirectory.
     *
     * Accepts values from 0 to 2^32 (4294967295).
     *
     * @experimental
     */
    readonly ownerUid: string;
    /**
     * (experimental) Specifies the POSIX group ID to apply to the RootDirectory.
     *
     * Accepts values from 0 to 2^32 (4294967295).
     *
     * @experimental
     */
    readonly ownerGid: string;
    /**
     * (experimental) Specifies the POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
     *
     * @experimental
     */
    readonly permissions: string;
}
/**
 * (experimental) Represents the PosixUser.
 *
 * @experimental
 */
export interface PosixUser {
    /**
     * (experimental) The POSIX user ID used for all file system operations using this access point.
     *
     * @experimental
     */
    readonly uid: string;
    /**
     * (experimental) The POSIX group ID used for all file system operations using this access point.
     *
     * @experimental
     */
    readonly gid: string;
    /**
     * (experimental) Secondary POSIX group IDs used for all file system operations using this access point.
     *
     * @default - None
     * @experimental
     */
    readonly secondaryGids?: string[];
}
/**
 * (experimental) Options to create an AccessPoint.
 *
 * @experimental
 */
export interface AccessPointOptions {
    /**
     * (experimental) Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.
     *
     * If the
     * root directory specified by `path` does not exist, EFS creates the root directory and applies the
     * permissions specified here. If the specified `path` does not exist, you must specify `createAcl`.
     *
     * @default - None. The directory specified by `path` must exist.
     * @experimental
     */
    readonly createAcl?: Acl;
    /**
     * (experimental) Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
     *
     * @default '/'
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.
     *
     * Specify this to enforce a user identity using an access point.
     *
     * @default - user identity not enforced
     * @see - [Enforcing a User Identity Using an Access Point](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)
     * @experimental
     */
    readonly posixUser?: PosixUser;
}
/**
 * (experimental) Properties for the AccessPoint.
 *
 * @experimental
 */
export interface AccessPointProps extends AccessPointOptions {
    /**
     * (experimental) The efs filesystem.
     *
     * @experimental
     */
    readonly fileSystem: IFileSystem;
}
/**
 * (experimental) Attributes that can be specified when importing an AccessPoint.
 *
 * @experimental
 */
export interface AccessPointAttributes {
    /**
     * (experimental) The ID of the AccessPoint One of this, or {@link accessPointArn} is required.
     *
     * @default - determined based on accessPointArn
     * @experimental
     */
    readonly accessPointId?: string;
    /**
     * (experimental) The ARN of the AccessPoint One of this, or {@link accessPointId} is required.
     *
     * @default - determined based on accessPointId
     * @experimental
     */
    readonly accessPointArn?: string;
    /**
     * (experimental) The EFS file system.
     *
     * @default - no EFS file system
     * @experimental
     */
    readonly fileSystem?: IFileSystem;
}
declare abstract class AccessPointBase extends Resource implements IAccessPoint {
    /**
     * The ARN of the Access Point
     * @attribute
     */
    abstract readonly accessPointArn: string;
    /**
     * The ID of the Access Point
     * @attribute
     */
    abstract readonly accessPointId: string;
    /**
     * The file system of the access point
     */
    abstract readonly fileSystem: IFileSystem;
}
/**
 * (experimental) Represents the AccessPoint.
 *
 * @experimental
 */
export declare class AccessPoint extends AccessPointBase {
    /**
     * (experimental) Import an existing Access Point by attributes.
     *
     * @experimental
     */
    static fromAccessPointAttributes(scope: Construct, id: string, attrs: AccessPointAttributes): IAccessPoint;
    /**
     * (experimental) Import an existing Access Point by id.
     *
     * @experimental
     */
    static fromAccessPointId(scope: Construct, id: string, accessPointId: string): IAccessPoint;
    /**
     * (experimental) The ARN of the Access Point.
     *
     * @experimental
     * @attribute true
     */
    readonly accessPointArn: string;
    /**
     * (experimental) The ID of the Access Point.
     *
     * @experimental
     * @attribute true
     */
    readonly accessPointId: string;
    /**
     * (experimental) The file system of the access point.
     *
     * @experimental
     */
    readonly fileSystem: IFileSystem;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AccessPointProps);
}
export {};
