"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.EFSMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class EFSMetrics {
    static dataReadIoBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'DataReadIOBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static dataWriteIoBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'DataWriteIOBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static clientConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'ClientConnections',
            dimensions,
            statistic: 'Sum',
        };
    }
    static burstCreditBalanceAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'BurstCreditBalance',
            dimensions,
            statistic: 'Average',
        };
    }
    static percentIoLimitAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'PercentIOLimit',
            dimensions,
            statistic: 'Average',
        };
    }
    static permittedThroughputAverage(dimensions) {
        return {
            namespace: 'AWS/EFS',
            metricName: 'PermittedThroughput',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EFSMetrics = EFSMetrics;
//# sourceMappingURL=data:application/json;base64,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