import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::EFS::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 * @external
 */
export interface CfnAccessPointProps {
    /**
     * `AWS::EFS::AccessPoint.FileSystemId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid
     * @external
     */
    readonly fileSystemId: string;
    /**
     * `AWS::EFS::AccessPoint.AccessPointTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags
     * @external
     */
    readonly accessPointTags?: Array<CfnAccessPoint.AccessPointTagProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EFS::AccessPoint.ClientToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken
     * @external
     */
    readonly clientToken?: string;
    /**
     * `AWS::EFS::AccessPoint.PosixUser`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser
     * @external
     */
    readonly posixUser?: CfnAccessPoint.PosixUserProperty | cdk.IResolvable;
    /**
     * `AWS::EFS::AccessPoint.RootDirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory
     * @external
     */
    readonly rootDirectory?: CfnAccessPoint.RootDirectoryProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EFS::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 * @external
 * @cloudformationResource AWS::EFS::AccessPoint
 */
export declare class CfnAccessPoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EFS::AccessPoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAccessPoint;
    /**
     * @external
     * @cloudformationAttribute AccessPointId
     */
    readonly attrAccessPointId: string;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::EFS::AccessPoint.FileSystemId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid
     * @external
     */
    fileSystemId: string;
    /**
     * `AWS::EFS::AccessPoint.AccessPointTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags
     * @external
     */
    accessPointTags: Array<CfnAccessPoint.AccessPointTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::AccessPoint.ClientToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken
     * @external
     */
    clientToken: string | undefined;
    /**
     * `AWS::EFS::AccessPoint.PosixUser`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser
     * @external
     */
    posixUser: CfnAccessPoint.PosixUserProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::AccessPoint.RootDirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory
     * @external
     */
    rootDirectory: CfnAccessPoint.RootDirectoryProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EFS::AccessPoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccessPointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EFS::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 * @external
 * @cloudformationResource AWS::EFS::AccessPoint
 */
export declare namespace CfnAccessPoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html
     * @external
     */
    interface AccessPointTagProperty {
        /**
         * `CfnAccessPoint.AccessPointTagProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html#cfn-efs-accesspoint-accesspointtag-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnAccessPoint.AccessPointTagProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html#cfn-efs-accesspoint-accesspointtag-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::EFS::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 * @external
 * @cloudformationResource AWS::EFS::AccessPoint
 */
export declare namespace CfnAccessPoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html
     * @external
     */
    interface CreationInfoProperty {
        /**
         * `CfnAccessPoint.CreationInfoProperty.OwnerGid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-ownergid
         * @external
         */
        readonly ownerGid: string;
        /**
         * `CfnAccessPoint.CreationInfoProperty.OwnerUid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-owneruid
         * @external
         */
        readonly ownerUid: string;
        /**
         * `CfnAccessPoint.CreationInfoProperty.Permissions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-permissions
         * @external
         */
        readonly permissions: string;
    }
}
/**
 * A CloudFormation `AWS::EFS::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 * @external
 * @cloudformationResource AWS::EFS::AccessPoint
 */
export declare namespace CfnAccessPoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html
     * @external
     */
    interface PosixUserProperty {
        /**
         * `CfnAccessPoint.PosixUserProperty.Gid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-gid
         * @external
         */
        readonly gid: string;
        /**
         * `CfnAccessPoint.PosixUserProperty.SecondaryGids`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-secondarygids
         * @external
         */
        readonly secondaryGids?: string[];
        /**
         * `CfnAccessPoint.PosixUserProperty.Uid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-uid
         * @external
         */
        readonly uid: string;
    }
}
/**
 * A CloudFormation `AWS::EFS::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 * @external
 * @cloudformationResource AWS::EFS::AccessPoint
 */
export declare namespace CfnAccessPoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html
     * @external
     */
    interface RootDirectoryProperty {
        /**
         * `CfnAccessPoint.RootDirectoryProperty.CreationInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html#cfn-efs-accesspoint-rootdirectory-creationinfo
         * @external
         */
        readonly creationInfo?: CfnAccessPoint.CreationInfoProperty | cdk.IResolvable;
        /**
         * `CfnAccessPoint.RootDirectoryProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html#cfn-efs-accesspoint-rootdirectory-path
         * @external
         */
        readonly path?: string;
    }
}
/**
 * Properties for defining a `AWS::EFS::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 * @external
 */
export interface CfnFileSystemProps {
    /**
     * `AWS::EFS::FileSystem.BackupPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy
     * @external
     */
    readonly backupPolicy?: CfnFileSystem.BackupPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.Encrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
     * @external
     */
    readonly encrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.FileSystemPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
     * @external
     */
    readonly fileSystemPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.FileSystemTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
     * @external
     */
    readonly fileSystemTags?: CfnFileSystem.ElasticFileSystemTagProperty[];
    /**
     * `AWS::EFS::FileSystem.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::EFS::FileSystem.LifecyclePolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
     * @external
     */
    readonly lifecyclePolicies?: Array<CfnFileSystem.LifecyclePolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.PerformanceMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
     * @external
     */
    readonly performanceMode?: string;
    /**
     * `AWS::EFS::FileSystem.ProvisionedThroughputInMibps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
     * @external
     */
    readonly provisionedThroughputInMibps?: number;
    /**
     * `AWS::EFS::FileSystem.ThroughputMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
     * @external
     */
    readonly throughputMode?: string;
}
/**
 * A CloudFormation `AWS::EFS::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 * @external
 * @cloudformationResource AWS::EFS::FileSystem
 */
export declare class CfnFileSystem extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EFS::FileSystem";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFileSystem;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute FileSystemId
     */
    readonly attrFileSystemId: string;
    /**
     * `AWS::EFS::FileSystem.BackupPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy
     * @external
     */
    backupPolicy: CfnFileSystem.BackupPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.Encrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
     * @external
     */
    encrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.FileSystemPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
     * @external
     */
    fileSystemPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.FileSystemTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EFS::FileSystem.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::EFS::FileSystem.LifecyclePolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
     * @external
     */
    lifecyclePolicies: Array<CfnFileSystem.LifecyclePolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.PerformanceMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
     * @external
     */
    performanceMode: string | undefined;
    /**
     * `AWS::EFS::FileSystem.ProvisionedThroughputInMibps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
     * @external
     */
    provisionedThroughputInMibps: number | undefined;
    /**
     * `AWS::EFS::FileSystem.ThroughputMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
     * @external
     */
    throughputMode: string | undefined;
    /**
     * Create a new `AWS::EFS::FileSystem`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnFileSystemProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EFS::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 * @external
 * @cloudformationResource AWS::EFS::FileSystem
 */
export declare namespace CfnFileSystem {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html
     * @external
     */
    interface BackupPolicyProperty {
        /**
         * `CfnFileSystem.BackupPolicyProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html#cfn-efs-filesystem-backuppolicy-status
         * @external
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::EFS::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 * @external
 * @cloudformationResource AWS::EFS::FileSystem
 */
export declare namespace CfnFileSystem {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html
     * @external
     */
    interface ElasticFileSystemTagProperty {
        /**
         * `CfnFileSystem.ElasticFileSystemTagProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnFileSystem.ElasticFileSystemTagProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::EFS::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 * @external
 * @cloudformationResource AWS::EFS::FileSystem
 */
export declare namespace CfnFileSystem {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html
     * @external
     */
    interface LifecyclePolicyProperty {
        /**
         * `CfnFileSystem.LifecyclePolicyProperty.TransitionToIA`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoia
         * @external
         */
        readonly transitionToIa: string;
    }
}
/**
 * Properties for defining a `AWS::EFS::MountTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
 * @external
 */
export interface CfnMountTargetProps {
    /**
     * `AWS::EFS::MountTarget.FileSystemId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
     * @external
     */
    readonly fileSystemId: string;
    /**
     * `AWS::EFS::MountTarget.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
     * @external
     */
    readonly securityGroups: string[];
    /**
     * `AWS::EFS::MountTarget.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
     * @external
     */
    readonly subnetId: string;
    /**
     * `AWS::EFS::MountTarget.IpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
     * @external
     */
    readonly ipAddress?: string;
}
/**
 * A CloudFormation `AWS::EFS::MountTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
 * @external
 * @cloudformationResource AWS::EFS::MountTarget
 */
export declare class CfnMountTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EFS::MountTarget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMountTarget;
    /**
     * @external
     * @cloudformationAttribute IpAddress
     */
    readonly attrIpAddress: string;
    /**
     * `AWS::EFS::MountTarget.FileSystemId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
     * @external
     */
    fileSystemId: string;
    /**
     * `AWS::EFS::MountTarget.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
     * @external
     */
    securityGroups: string[];
    /**
     * `AWS::EFS::MountTarget.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
     * @external
     */
    subnetId: string;
    /**
     * `AWS::EFS::MountTarget.IpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
     * @external
     */
    ipAddress: string | undefined;
    /**
     * Create a new `AWS::EFS::MountTarget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMountTargetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
