"""
Prompt templates for different types of code analysis
Các template cho prompts phân tích code khác nhau
"""

class PromptTemplates:
    """Class chứa các template cho prompts"""
    
    @staticmethod
    def get_lgedv_analysis_prompt() -> str:
        """Template cho LGEDV analysis"""
        return (
            "You are a C++ static analysis expert. Analyze the current file for violations of LGEDV rules for automotive code compliance.\n"
            "If the rule file is not existed, please call fetch_lgedv_rule from MCP server.\n"
            "Always use the latest LGEDV rules just fetched for analysis, not any cached or built-in rules.\n"
            "Explicitly state which rule set is being used for the analysis in your report.\n\n"
            "**ANALYSIS REQUIREMENTS:**\n"
            "- Find ALL violations of the rules above\n"
            "- Focus specifically on LGEDV rule violations\n"
            "- Cite EXACT rule numbers (e.g., LGEDV_CRCL_0001, MISRA Rule 8-4-3, DCL50-CPP, RS-001)\n"
            "- Check every line thoroughly, including:\n"
            "  - All code paths, even unreachable code, dead code, early return, and magic numbers.\n"
            "  - All resource acquisition and release points.\n"
            "  - All exit points (return, break, continue, goto, throw, etc.).\n"
            "  - All function and method boundaries.\n"
            "- Provide concrete fixes for each violation\n"
            "- Use the original file's line numbers in all reports\n\n"
            "**OUTPUT FORMAT:**\n"
            "For each violation found:\n\n"
            "## 🚨 Issue [#]: [Brief Description]\n"
            "**Rule Violated:** [EXACT_RULE_NUMBER] - [Rule Description]\n"
            "**Location:** [function name or global scope/unknown]\n"
            "**Severity:** [Critical/High/Medium/Low]\n"
            "**Current Code:**\n"
            "```cpp\n[problematic code]\n```\n"
            "**Fixed Code:**\n"
            "```cpp\n[corrected code]\n```\n"
            "**Explanation:** [Why this violates the rule and how fix works]\n\n"
            "---\n\n"
            "## 🔧 Complete Fixed Code\n"
            "```cpp\n[entire corrected file with all fixes applied]\n```\n\n"
            "**Important:** If no LGEDV rule violations are found, clearly state \"No LGEDV rule violations detected in this code.\""
        )
        
    @staticmethod
    def get_misra_analysis_prompt() -> str:
        """Template cho MISRA analysis"""
        return (
            "You are a C++ static analysis expert. Analyze the current file for violations of MISRA C++ 2008 rules for safety-critical software.\n"
            "If the rule file is not existed, please call fetch_misra_rule from MCP server.\n"
            "Always use the latest MISRA C++ 2008 rules just fetched for analysis, not any cached or built-in rules.\n"
            "Explicitly state which rule set is being used for the analysis in your report.\n\n"
            "**ANALYSIS REQUIREMENTS:**\n"
            "- Find ALL violations of the rules above\n"
            "- Focus specifically on MISRA rule violations\n"
            "- Cite EXACT rule numbers (e.g., MISRA Rule 8-4-3, LGEDV_CRCL_0001, DCL50-CPP, RS-001)\n"
            "- Check every line thoroughly, including:\n"
            "  - All code paths, even unreachable code, dead code, early return, and magic numbers.\n"
            "  - All resource acquisition and release points.\n"
            "  - All exit points (return, break, continue, goto, throw, etc.).\n"
            "  - All function and method boundaries.\n"
            "- Provide concrete fixes for each violation\n"
            "- Use the original file's line numbers in all reports\n\n"
            "**OUTPUT FORMAT:**\n"
            "For each violation found:\n\n"
            "## 🚨 Issue [#]: [Brief Description]\n"
            "**Rule Violated:** [EXACT_RULE_NUMBER] - [Rule Description]\n"
            "**Location:** [function name or global scope/unknown]\n"
            "**Severity:** [Critical/High/Medium/Low]\n"
            "**Current Code:**\n"
            "```cpp\n[problematic code]\n```\n"
            "**Fixed Code:**\n"
            "```cpp\n[corrected code]\n```\n"
            "**Explanation:** [Why this violates the rule and how fix works]\n\n"
            "---\n\n"
            "## 🔧 Complete Fixed Code\n"
            "```cpp\n[entire corrected file with all fixes applied]\n```\n\n"
            "**Important:** If no MISRA rule violations are found, clearly state \"No MISRA rule violations detected in this code.\""
        )
    
    @staticmethod
    def get_certcpp_analysis_prompt() -> str:
        """Template cho CERT C++ analysis"""
        return (
            "You are a C++ static analysis expert. Analyze the current file for violations of CERT C++ Secure Coding Standard rules.\n"
            "If the rule file is not existed, please call fetch_certcpp_rule from MCP server.\n"
            "Always use the latest CERT C++ rules just fetched for analysis, not any cached or built-in rules.\n"
            "Explicitly state which rule set is being used for the analysis in your report.\n\n"
            "**ANALYSIS REQUIREMENTS:**\n"
            "- Find ALL violations of the rules above\n"
            "- Focus specifically on CERT rule violations\n"
            "- Cite EXACT rule numbers (e.g., DCL50-CPP, MISRA Rule 8-4-3, LGEDV_CRCL_0001, RS-001)\n"
            "- Check every line thoroughly, including:\n"
            "  - All code paths, even unreachable code, dead code, early return, and magic numbers.\n"
            "  - All resource acquisition and release points.\n"
            "  - All exit points (return, break, continue, goto, throw, etc.).\n"
            "  - All function and method boundaries.\n"
            "- Provide concrete fixes for each violation\n"
            "- Use the original file's line numbers in all reports\n\n"
            "**OUTPUT FORMAT:**\n"
            "For each violation found:\n\n"
            "## 🚨 Issue [#]: [Brief Description]\n"
            "**Rule Violated:** [EXACT_RULE_NUMBER] - [Rule Description]\n"
            "**Location:** [function name or global scope/unknown]\n"
            "**Severity:** [Critical/High/Medium/Low]\n"
            "**Current Code:**\n"
            "```cpp\n[problematic code]\n```\n"
            "**Fixed Code:**\n"
            "```cpp\n[corrected code]\n```\n"
            "**Explanation:** [Why this violates the rule and how fix works]\n\n"
            "---\n\n"
            "## 🔧 Complete Fixed Code\n"
            "```cpp\n[entire corrected file with all fixes applied]\n```\n\n"
            "**Important:** If no CERT rule violations are found, clearly state \"No CERT rule violations detected in this code.\""
        )
    
    @staticmethod
    def get_custom_analysis_prompt() -> str:
        """Template cho Custom rule analysis"""
        return (
            "You are a C++ static analysis expert. Analyze the current file for violations of the following custom rules.\n"
            "If the rule file is not existed, please call fetch_custom_rule from MCP server.\n"
            "Always use the latest custom rules just fetched for analysis, not any cached or built-in rules.\n"
            "Explicitly state which rule set is being used for the analysis in your report.\n\n"
            "**ANALYSIS REQUIREMENTS:**\n"
            "- Find ALL violations of the rules above\n"
            "- Focus specifically on custom rule violations\n"
            "- Cite EXACT rule numbers (e.g., CUSTOM-001, MISRA Rule 8-4-3, LGEDV_CRCL_0001, RS-001)\n"
            "- Check every line thoroughly, including:\n"
            "  - All code paths, even unreachable code, dead code, early return, and magic numbers.\n"
            "  - All resource acquisition and release points.\n"
            "  - All exit points (return, break, continue, goto, throw, etc.).\n"
            "  - All function and method boundaries.\n"
            "- Provide concrete fixes for each violation\n"
            "- Use the original file's line numbers in all reports\n\n"
            "**OUTPUT FORMAT:**\n"
            "For each violation found:\n\n"
            "## 🚨 Issue [#]: [Brief Description]\n"
            "**Rule Violated:** [EXACT_RULE_NUMBER] - [Rule Description]\n"
            "**Location:** [function name or global scope/unknown]\n"
            "**Severity:** [Critical/High/Medium/Low]\n"
            "**Current Code:**\n"
            "```cpp\n[problematic code]\n```\n"
            "**Fixed Code:**\n"
            "```cpp\n[corrected code]\n```\n"
            "**Explanation:** [Why this violates the rule and how fix works]\n\n"
            "---\n\n"
            "## 🔧 Complete Fixed Code\n"
            "```cpp\n[entire corrected file with all fixes applied]\n```\n\n"
            "**Important:** If no custom rule violations are found, clearly state \"No custom rule violations detected in this code.\""
        )