#!/usr/bin/env python

import io
import os
import string
import sys

import _Emhaplofreq

data_ar = [
    ["0701:", "1501:", "0102:", "0300:", "0201:", "0602:", "0201:", "0402:"],
    ["1101:", "1501:", "0102:", "0501:", "0301:", "0602:", "1101:", "1801:"],
]

# data_ar = [['0701:','1501:','0102:','0300:','0201:','0602:','0201:','0402:'], ['1101:','1501:','0102:','0501:','0301:','0602:','1101:','1801:'], ['0302:','****:','0401:','****:','0402:','****:','0101:','0402:'], ['0302:','1501:','0102:','0401:','0402:','0602:','0101:','0201:'], ['0802:','1302:','0102:','0501:','0301:','0604:','0201:','1501:'], ['1001:','1302:','0102:','****:','0501:','0604:','0201:','0401:'], ['0701:','1302:','0102:','0201:','0201:','0605:','0201:','0401:'], ['0302:','1101:','0102:','0401:','0402:','0602:','0301:','0402:'], ['0302:','****:','0401:','****:','0402:','****:','0101:','1101:'], ['0301:','1101:','0102:','0501:','0201:','0602:','0301:','0402:'], ['1201:','1301:','0103:','****:','0501:','0603:','0101:','0201:'], ['0301:','****:','0501:','****:','0201:','0301:','0101:','0402:'], ['0302:','1101:','0401:','0501:','0301:','0402:','0101:','****:'], ['0302:','1501:','0102:','0401:','0402:','0602:','0101:','0201:'], ['1100:','1300:','0102:','0501:','0301:','0501:','1301:','1801:'], ['0101:','1101:','0102:','****:','0501:','0602:','0101:','0402:'], ['0701:','1101:','0300:','0501:','0201:','0301:','0101:','0402:'], ['0901:','1302:','0102:','0300:','0200:','0605:','0101:','****:'], ['0101:','0302:','0101:','0401:','0402:','0501:','0101:','****:'], ['0302:','1101:','0102:','0401:','0402:','0602:','0402:','0501:'], ['0302:','1102:','0401:','0501:','0301:','0402:','0101:','1301:'], ['1302:','****:','0103:','****:','0602:','0605:','0301:','1001:'], ['0101:','0302:','0101:','0401:','0402:','0501:','0101:','****:'], ['0302:','1101:','0401:','0501:','0301:','0402:','0101:','1301:'], ['0301:','0701:','0300:','0501:','0200:','****:','0201:','0402:'], ['0405:','****:','0201:','0300:','0201:','0302:','0301:','1301:'], ['0101:','0401:','0101:','0300:','0302:','0501:','0101:','0402:'], ['****:','****:','0501:','****:','0201:','0301:','****:','****:']]

for i in data_ar:
    print("obs:", end="")
    for j in i:
        print("locus", j, end="")
    print()

recs = len(data_ar)
loci = len(data_ar[0]) / 2

print("obs:", recs, "loci:", loci)

# save regular stdout
print("before saving stdout")
stdout = sys.stdout

# create a buffer for capturing stdout and redirect stdout to this buffer
sys.stdout = file = io.StringIO()

# use an in-memory file instance for the C program to write to

fp = io.StringIO()

# call the SWIG-ed method
_Emhaplofreq.main_proc(fp, data_ar, loci, recs, 0)
lines = string.split(fp.getvalue(), os.linesep)

# print the in-memory file to sys.stdout
for i in lines:
    print(">", i)
fp.close()

# reassign stdout back to sys.stdout
sys.stdout = stdout

# print out saved buffer
print("outputting captured stdout")
print(file.getvalue())
