# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTwingateResourceResult',
    'AwaitableGetTwingateResourceResult',
    'get_twingate_resource',
    'get_twingate_resource_output',
]

@pulumi.output_type
class GetTwingateResourceResult:
    """
    A collection of values returned by getTwingateResource.
    """
    def __init__(__self__, address=None, id=None, name=None, protocols=None, remote_network_id=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocols and not isinstance(protocols, dict):
            raise TypeError("Expected argument 'protocols' to be a dict")
        pulumi.set(__self__, "protocols", protocols)
        if remote_network_id and not isinstance(remote_network_id, str):
            raise TypeError("Expected argument 'remote_network_id' to be a str")
        pulumi.set(__self__, "remote_network_id", remote_network_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The Resource's address, which may be an IP address, CIDR range, or DNS address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Resource. The ID for the Resource can be obtained from the Admin API or the URL string in the Admin Console.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional['outputs.GetTwingateResourceProtocolsResult']:
        """
        By default (when this argument is not defined) no restriction is applied, and all protocols and ports are allowed.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> str:
        """
        The Remote Network ID that the Resource is associated with. Resources may only be associated with a single Remote Network.
        """
        return pulumi.get(self, "remote_network_id")


class AwaitableGetTwingateResourceResult(GetTwingateResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTwingateResourceResult(
            address=self.address,
            id=self.id,
            name=self.name,
            protocols=self.protocols,
            remote_network_id=self.remote_network_id)


def get_twingate_resource(id: Optional[str] = None,
                          protocols: Optional[pulumi.InputType['GetTwingateResourceProtocolsArgs']] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTwingateResourceResult:
    """
    Resources in Twingate represent any network destination address that you wish to provide private access to for users authorized via the Twingate Client application. Resources can be defined by either IP or DNS address, and all private DNS addresses will be automatically resolved with no client configuration changes. For more information, see the Twingate [documentation](https://docs.twingate.com/docs/resources-and-access-nodes).

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_twingate as twingate

    foo = twingate.get_twingate_resource(id="<your resource's id>")
    ```
    <!--End PulumiCodeChooser -->


    :param str id: The ID of the Resource. The ID for the Resource can be obtained from the Admin API or the URL string in the Admin Console.
    :param pulumi.InputType['GetTwingateResourceProtocolsArgs'] protocols: By default (when this argument is not defined) no restriction is applied, and all protocols and ports are allowed.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['protocols'] = protocols
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('twingate:index/getTwingateResource:getTwingateResource', __args__, opts=opts, typ=GetTwingateResourceResult).value

    return AwaitableGetTwingateResourceResult(
        address=pulumi.get(__ret__, 'address'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        protocols=pulumi.get(__ret__, 'protocols'),
        remote_network_id=pulumi.get(__ret__, 'remote_network_id'))


@_utilities.lift_output_func(get_twingate_resource)
def get_twingate_resource_output(id: Optional[pulumi.Input[str]] = None,
                                 protocols: Optional[pulumi.Input[Optional[pulumi.InputType['GetTwingateResourceProtocolsArgs']]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTwingateResourceResult]:
    """
    Resources in Twingate represent any network destination address that you wish to provide private access to for users authorized via the Twingate Client application. Resources can be defined by either IP or DNS address, and all private DNS addresses will be automatically resolved with no client configuration changes. For more information, see the Twingate [documentation](https://docs.twingate.com/docs/resources-and-access-nodes).

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_twingate as twingate

    foo = twingate.get_twingate_resource(id="<your resource's id>")
    ```
    <!--End PulumiCodeChooser -->


    :param str id: The ID of the Resource. The ID for the Resource can be obtained from the Admin API or the URL string in the Admin Console.
    :param pulumi.InputType['GetTwingateResourceProtocolsArgs'] protocols: By default (when this argument is not defined) no restriction is applied, and all protocols and ports are allowed.
    """
    ...
