# Game Organizer

**Game Organizer** is a Python application that helps you easily organize your board and card games by allowing you to input your game collection along with shelving information (rows and columns). Perfect for keeping track of your collection in a structured way!

## Features

* Add new games to your collection.
* Assign each game a specific shelf location using rows and columns.
* Easily view and manage your organized collection.
* Works for both board games and card games.

## Installation

1. Clone the repository:

```bash
git clone https://github.com/dragonruler1000/Game-organizer.git
cd game-organizer
```

2. Install [Poetry](https://python-poetry.org/) if you don’t already have it:

* **Bash (Linux/macOS):**

```bash
curl -sSL https://install.python-poetry.org | python3 -
```

* **PowerShell (Windows):**

```powershell
(Invoke-WebRequest -Uri https://install.python-poetry.org -UseBasicParsing).Content | py -
```

3. Install project dependencies using Poetry:

```bash
poetry install
```

4. Activate the virtual environment (optional, but recommended):

```bash
poetry shell
```

## Usage

1. Run the main script:

```bash
python main.py
```

2. Follow the prompts to:

   * Add a game to your collection
   * Input shelving information (number of rows and columns)
   * View your organized collection

Example:

```
Enter game name: Catan
Enter game type (Board/Card): Board
Enter shelf row: 2
Enter shelf column: 3
Game added successfully!
```

## Contributing

Contributions are welcome! Feel free to submit issues, suggest features, or submit pull requests.

## License

This project is licensed under the MIT License.

See the [LICENSE](LICENSE) file for details.