from setuptools import setup, find_packages

setup(
    name="spamosaic",
    version="1.0.0",
    author="Jinmiao Lab",
    author_email="contact@jinmiaolab.org",
    description="SpaMosaic: mosaic integration of spatial multi-omics with GNN and contrastive learning",
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/JinmiaoChenLab/SpaMosaic",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
    ],
    python_requires=">=3.8",
    install_requires=[
        "anndata==0.12.1",
        "annoy==1.17.3",
        "h5py==3.10.0",
        "harmony-pytorch==0.1.7",
        "hnswlib==0.8.0",
        "matplotlib==3.7.4",
        "networkx==3.1",
        "numpy==1.22.4",
        "pandas==1.5.3",
        "PyYAML==6.0.2",
        "scanpy==1.11.4",
        "scikit-learn==1.3.2",
        "scipy==1.16.1",
        "seaborn==0.13.2",
        "torch==2.0.0",
        "torch-geometric==2.6.1",
        "torch-scatter==2.1.2",
        "torch-sparse==0.6.18",
        "tqdm==4.66.1"
    ],
    include_package_data=True,
    zip_safe=False,
)
