# Generated by Django 4.2.23 on 2025-09-04 19:21

from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    dependencies = [
        ('jobs', '0001_initial'),
    ]

    operations = [
        migrations.AlterField(
            model_name='job',
            name='max_retries',
            field=models.IntegerField(default=0, help_text='Maximum retry attempts'),
        ),
        migrations.CreateModel(
            name='JobLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('channel', models.CharField(db_index=True, max_length=100)),
                ('kind', models.CharField(choices=[('debug', 'Debug'), ('info', 'Info'), ('warn', 'Warn'), ('error', 'Error')], db_index=True, default='info', help_text='Log level/kind', max_length=16)),
                ('message', models.TextField(help_text='Log message')),
                ('meta', models.JSONField(blank=True, default=dict, help_text='Optional structured context')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='jobs.job')),
            ],
            options={
                'db_table': 'jobs_joblog',
                'ordering': ['-created'],
                'indexes': [models.Index(fields=['job', '-created'], name='jobs_joblog_job_id_e9a555_idx'), models.Index(fields=['channel', 'kind', '-created'], name='jobs_joblog_channel_245a26_idx'), models.Index(fields=['-created'], name='jobs_joblog_created_41aac8_idx')],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
