"""This module is for the translation mapping data of the
following document:

Document file: animation_interfaces_abstract.md
Language: jp
"""

from typing import Dict

MAPPING: Dict[str, str] = {

    '# Animation interfaces abstract':
    '# 各アニメーションインターフェイス概要',

    'This page explains the animation interfaces\' abstract.':
    'このページでは各アニメーションの概要について説明します。',

    '## What apysc can do in its animation interfaces':
    '## apyscの各アニメーションのインターフェイスで出来ること',

    '- You can animate each attribute, such as the coordinates, rotation, color, alpha (opacity), scale.':  # noqa
    '- 座標値や回転量、色や透明度、拡縮値などの各属性に対してアニメーションを行うことができます。',

    '- You can set the animation\'s duration in milliseconds.':
    '- 何ミリ秒かけてアニメーションするかを設定することができます。',

    '- You can set the animation\'s delay in milliseconds.':
    '- アニメーション開始前の遅延時間をミリ秒単位で設定することができます。',

    '- You can use many easing settings, such as the `EASE_IN_CUBIC`\\, `EASE_OUT_QUINT`\\, and `EASE_IN_OUT_BOUNCE`\\.':  # noqa
    '- `EASE_IN_CUBIC`や`EASE_OUT_QUINT`、`EASE_IN_OUT_BOUNCE`などのイージングの設定を行うことができます。',  # noqa

    '- You can control the target instance\'s animation with the pause, play, reset, finish, reverse, time interfaces.':  # noqa
    '- 一時停止、再生、リセット、終了、逆再生、経過時間取得などのアニメーション関係の制御を行うことができます。',

    '- You can set the parallel animation or sequential animation.':
    '- アニメーションの並列実行や直列実行を設定することができます。',

    '- Animation complete event is supported.':
    '- アニメーション終了時のイベント設定をサポートしています。',

    '## Examples of each attribute animation':
    '## 各属性のアニメーション設定例',

    'This section will show each attribute animation example:':
    'この節では各属性のアニメーション設定例を表示します。',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=550, stage_height=550, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nsprite.graphics.line_style(color=\'#fff\', thickness=1)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_x_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the x-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_x_animation_complete_2).start()\n\n\ndef on_x_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the x-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_x_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_x_animation_complete_1).start()\n\n\ndef on_y_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the y-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_y_animation_complete_2).start()\n\n\ndef on_y_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the y-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_y_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=50, width=50, height=50,\n).animation_y(\n    y=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_y_animation_complete_1).start()\n\n\ndef on_cx_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=275, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cx_animation_complete_2).start()\n\n\ndef on_cx_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=325, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cx_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=275, y=75, radius=25,\n).animation_x(\n    x=325, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_cx_animation_complete_1).start()\n\n\ndef on_cy_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-y animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=75, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cy_animation_complete_2).start()\n\n\ndef on_cy_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-y animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=25, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cy_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=375, y=75, radius=25,\n).animation_y(\n    y=25, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_cy_animation_complete_1).start()\n\n\ndef on_move_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that move-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=450, y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_move_animation_complete_2).start()\n\n\ndef on_move_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that move-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=500, y=0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_move_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=450, y=50, width=50, height=50,\n).animation_move(\n    x=500, y=0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_move_animation_complete_1).start()\n\n\ndef on_width_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_width_animation_complete_2).start()\n\n\ndef on_width_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_width_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50,\n).animation_width(\n    width=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_width_animation_complete_1).start()\n\n\ndef on_height_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_height_animation_complete_2).start()\n\n\ndef on_height_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_height_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=150, width=50, height=50,\n).animation_height(\n    height=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_height_animation_complete_1).start()\n\n\ndef on_ellipse_width_animation_complete_1(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_width_animation_complete_2).start()\n\n\ndef on_ellipse_width_animation_complete_2(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_width_animation_complete_1).start()\n\n\nsprite.graphics.draw_ellipse(\n    x=275, y=175, width=50, height=50,\n).animation_width(\n    width=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_ellipse_width_animation_complete_1).start()\n\n\ndef on_ellipse_height_animation_complete_1(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_height_animation_complete_2).start()\n\n\ndef on_ellipse_height_animation_complete_2(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_height_animation_complete_1).start()\n\n\nsprite.graphics.draw_ellipse(\n    x=375, y=175, width=50, height=50,\n).animation_height(\n    height=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_ellipse_height_animation_complete_1).start()\n\n\ndef on_fill_color_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#0af\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_color_animation_complete_2).start()\n\n\ndef on_fill_color_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_color_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=450, y=150, width=50, height=50,\n).animation_fill_color(\n    fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_fill_color_animation_complete_1).start()\n\n\ndef on_fill_alpha_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_alpha_animation_complete_2).start()\n\n\ndef on_fill_alpha_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_alpha_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50,\n).animation_fill_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_fill_alpha_animation_complete_1).start()\n\n\ndef on_line_color_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#fff\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_color_animation_complete_2).start()\n\n\ndef on_line_color_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#666\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_color_animation_complete_1).start()\n\n\nsprite.graphics.line_style(color=\'#fff\', thickness=5)\nsprite.graphics.draw_rect(\n    x=150, y=250, width=50, height=50,\n).animation_line_color(\n    line_color=\'#666\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_line_color_animation_complete_1).start()\n\n\ndef on_line_alpha_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_alpha_animation_complete_2).start()\n\n\ndef on_line_alpha_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_alpha_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=250, y=250, width=50, height=50,\n).animation_line_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_line_alpha_animation_complete_1).start()\nsprite.graphics.line_style(color=\'#fff\', thickness=1)\n\n\ndef on_line_thickness_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-thickness animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=1, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_thickness_animation_complete_2).start()\n\n\ndef on_line_thickness_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-thickness animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_thickness_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=350, y=250, width=50, height=50,\n).animation_line_thickness(\n    thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_line_thickness_animation_complete_1).start()\n\n\ndef on_radius_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the radius-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=25, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_radius_animation_complete_2).start()\n\n\ndef on_radius_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the radius-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_radius_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=475, y=275, radius=25,\n).animation_radius(\n    radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_radius_animation_complete_1).start()\n\n\ndef on_rotation_around_center_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(\n        on_rotation_around_center_animation_complete_2,\n    ).start()\n\n\ndef on_rotation_around_center_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=90, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(\n        on_rotation_around_center_animation_complete_1,\n    ).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=350, width=50, height=50,\n).animation_rotation_around_center(\n    rotation_around_center=90, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_rotation_around_center_animation_complete_1).start()\n\n\ndef on_rotation_around_point_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=0,\n        x=200, y=400, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(\n        on_rotation_around_point_animation_complete_2,\n    ).start()\n\n\ndef on_rotation_around_point_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=90,\n        x=200, y=400, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(\n        on_rotation_around_point_animation_complete_1,\n    ).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=350, width=50, height=50,\n).animation_rotation_around_point(\n    rotation_around_point=90,\n    x=200, y=400, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_rotation_around_point_animation_complete_1).start()\n\n\ndef on_scale_x_from_center_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_center_animation_complete_2).start()\n\n\ndef on_scale_x_from_center_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_center_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=250, y=350, width=50, height=50,\n).animation_scale_x_from_center(\n    scale_x_from_center=0.5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_scale_x_from_center_animation_complete_1).start()\n\n\ndef on_scale_y_from_center_animation_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the center point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_center_animation_2).start()\n\n\ndef on_scale_y_from_center_animation_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the center point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_center_animation_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=350, y=350, width=50, height=50,\n).animation_scale_y_from_center(\n    scale_y_from_center=0.5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_scale_y_from_center_animation_1).start()\n\n\ndef on_scale_x_from_point_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=1.0, x=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_point_animation_complete_2).start()\n\n\ndef on_scale_x_from_point_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=0.5, x=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_point_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=450, y=350, width=50, height=50,\n).animation_scale_x_from_point(\n    scale_x_from_point=0.5, x=500, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_scale_x_from_point_animation_complete_1).start()\n\n\ndef on_scale_y_from_point_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=1.0, y=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_point_animation_complete_2).start()\n\n\ndef on_scale_y_from_point_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=0.5, y=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_point_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=450, width=50, height=50,\n).animation_scale_y_from_point(\n    scale_y_from_point=0.5, y=500, duration=DURATION, delay=DELAY,\n).animation_complete(on_scale_y_from_point_animation_complete_1).start()\n\n\ndef on_skew_x_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the skew-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_skew_x_animation_complete_2).start()\n\n\ndef on_skew_x_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the skew-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=30, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_skew_x_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=450, width=50, height=50,\n).animation_skew_x(\n    skew_x=30, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_skew_x_animation_complete_1).start()\n\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_each_attr/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=550, stage_height=550, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nsprite.graphics.line_style(color=\'#fff\', thickness=1)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_x_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the x-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_x_animation_complete_2).start()\n\n\ndef on_x_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the x-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_x_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_x_animation_complete_1).start()\n\n\ndef on_y_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the y-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_y_animation_complete_2).start()\n\n\ndef on_y_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the y-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_y_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=50, width=50, height=50,\n).animation_y(\n    y=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_y_animation_complete_1).start()\n\n\ndef on_cx_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=275, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cx_animation_complete_2).start()\n\n\ndef on_cx_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=325, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cx_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=275, y=75, radius=25,\n).animation_x(\n    x=325, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_cx_animation_complete_1).start()\n\n\ndef on_cy_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-y animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=75, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cy_animation_complete_2).start()\n\n\ndef on_cy_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the center-y animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=25, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_cy_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=375, y=75, radius=25,\n).animation_y(\n    y=25, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_cy_animation_complete_1).start()\n\n\ndef on_move_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that move-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=450, y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_move_animation_complete_2).start()\n\n\ndef on_move_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that move-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=500, y=0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_move_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=450, y=50, width=50, height=50,\n).animation_move(\n    x=500, y=0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_move_animation_complete_1).start()\n\n\ndef on_width_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_width_animation_complete_2).start()\n\n\ndef on_width_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_width_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50,\n).animation_width(\n    width=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_width_animation_complete_1).start()\n\n\ndef on_height_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_height_animation_complete_2).start()\n\n\ndef on_height_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_height_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=150, width=50, height=50,\n).animation_height(\n    height=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_height_animation_complete_1).start()\n\n\ndef on_ellipse_width_animation_complete_1(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_width_animation_complete_2).start()\n\n\ndef on_ellipse_width_animation_complete_2(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-width animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_width_animation_complete_1).start()\n\n\nsprite.graphics.draw_ellipse(\n    x=275, y=175, width=50, height=50,\n).animation_width(\n    width=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_ellipse_width_animation_complete_1).start()\n\n\ndef on_ellipse_height_animation_complete_1(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_height_animation_complete_2).start()\n\n\ndef on_ellipse_height_animation_complete_2(\n        e: ap.AnimationEvent[ap.Ellipse], options: dict) -> None:\n    """\n    The handler that the ellipse-height animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_ellipse_height_animation_complete_1).start()\n\n\nsprite.graphics.draw_ellipse(\n    x=375, y=175, width=50, height=50,\n).animation_height(\n    height=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_ellipse_height_animation_complete_1).start()\n\n\ndef on_fill_color_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#0af\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_color_animation_complete_2).start()\n\n\ndef on_fill_color_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_color_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=450, y=150, width=50, height=50,\n).animation_fill_color(\n    fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_fill_color_animation_complete_1).start()\n\n\ndef on_fill_alpha_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_alpha_animation_complete_2).start()\n\n\ndef on_fill_alpha_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the fill-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_fill_alpha_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50,\n).animation_fill_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_fill_alpha_animation_complete_1).start()\n\n\ndef on_line_color_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#fff\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_color_animation_complete_2).start()\n\n\ndef on_line_color_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-color animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#666\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_color_animation_complete_1).start()\n\n\nsprite.graphics.line_style(color=\'#fff\', thickness=5)\nsprite.graphics.draw_rect(\n    x=150, y=250, width=50, height=50,\n).animation_line_color(\n    line_color=\'#666\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_line_color_animation_complete_1).start()\n\n\ndef on_line_alpha_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_alpha_animation_complete_2).start()\n\n\ndef on_line_alpha_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-alpha animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_alpha_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=250, y=250, width=50, height=50,\n).animation_line_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_line_alpha_animation_complete_1).start()\nsprite.graphics.line_style(color=\'#fff\', thickness=1)\n\n\ndef on_line_thickness_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-thickness animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=1, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_thickness_animation_complete_2).start()\n\n\ndef on_line_thickness_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the line-thickness animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_line_thickness_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=350, y=250, width=50, height=50,\n).animation_line_thickness(\n    thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_line_thickness_animation_complete_1).start()\n\n\ndef on_radius_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the radius-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=25, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_radius_animation_complete_2).start()\n\n\ndef on_radius_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the radius-animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_radius_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=475, y=275, radius=25,\n).animation_radius(\n    radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_radius_animation_complete_1).start()\n\n\ndef on_rotation_around_center_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(\n        on_rotation_around_center_animation_complete_2,\n    ).start()\n\n\ndef on_rotation_around_center_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=90, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(\n        on_rotation_around_center_animation_complete_1,\n    ).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=350, width=50, height=50,\n).animation_rotation_around_center(\n    rotation_around_center=90, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_rotation_around_center_animation_complete_1).start()\n\n\ndef on_rotation_around_point_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=0,\n        x=200, y=400, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(\n        on_rotation_around_point_animation_complete_2,\n    ).start()\n\n\ndef on_rotation_around_point_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the rotation around the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=90,\n        x=200, y=400, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(\n        on_rotation_around_point_animation_complete_1,\n    ).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=350, width=50, height=50,\n).animation_rotation_around_point(\n    rotation_around_point=90,\n    x=200, y=400, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_rotation_around_point_animation_complete_1).start()\n\n\ndef on_scale_x_from_center_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_center_animation_complete_2).start()\n\n\ndef on_scale_x_from_center_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the center point animation\n    calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_center_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=250, y=350, width=50, height=50,\n).animation_scale_x_from_center(\n    scale_x_from_center=0.5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_scale_x_from_center_animation_complete_1).start()\n\n\ndef on_scale_y_from_center_animation_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the center point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_center_animation_2).start()\n\n\ndef on_scale_y_from_center_animation_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the center point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_center_animation_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=350, y=350, width=50, height=50,\n).animation_scale_y_from_center(\n    scale_y_from_center=0.5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_scale_y_from_center_animation_1).start()\n\n\ndef on_scale_x_from_point_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=1.0, x=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_point_animation_complete_2).start()\n\n\ndef on_scale_x_from_point_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-x from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=0.5, x=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_x_from_point_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=450, y=350, width=50, height=50,\n).animation_scale_x_from_point(\n    scale_x_from_point=0.5, x=500, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_scale_x_from_point_animation_complete_1).start()\n\n\ndef on_scale_y_from_point_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=1.0, y=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_point_animation_complete_2).start()\n\n\ndef on_scale_y_from_point_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the scale-y from the specified point\n    animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=0.5, y=500, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_scale_y_from_point_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=450, width=50, height=50,\n).animation_scale_y_from_point(\n    scale_y_from_point=0.5, y=500, duration=DURATION, delay=DELAY,\n).animation_complete(on_scale_y_from_point_animation_complete_1).start()\n\n\ndef on_skew_x_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the skew-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_skew_x_animation_complete_2).start()\n\n\ndef on_skew_x_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the skew-x animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=30, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_skew_x_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=150, y=450, width=50, height=50,\n).animation_skew_x(\n    skew_x=30, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_skew_x_animation_complete_1).start()\n\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_each_attr/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Easing':
    '## イージング',

    'The easing setting can be set with the `easing` argument of each animation interface. For more details:':  # noqa
    'イージング設定は各インターフェイスの`easing`引数で設定することができます。詳細は以下を参照してください:',

    '- [Easing enum document](easing_enum.md)':
    '- [イージングのenum](jp_easing_enum.md)',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\n\n\nclass EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=50, duration=DURATION, delay=DELAY,\n        easing=options[\'easing\'],\n    ).animation_complete(\n        on_animation_complete_2, options=options,\n    ).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=100, duration=DURATION, delay=DELAY,\n        easing=options[\'easing\'],\n    ).animation_complete(\n        on_animation_complete_1, options=options,\n    ).start()\n\n\noptions: EasingOptions = {\'easing\': ap.Easing.EASE_IN_QUINT}\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY,\n    easing=options[\'easing\'],\n).animation_complete(\n    on_animation_complete_1, options=options,\n).start()\n\noptions = {\'easing\': ap.Easing.EASE_OUT_QUINT}\nsprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY,\n    easing=options[\'easing\'],\n).animation_complete(\n    on_animation_complete_1, options=options,\n).start()\n\noptions = {\'easing\': ap.Easing.EASE_IN_OUT_QUINT}\nsprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY,\n    easing=options[\'easing\'],\n).animation_complete(\n    on_animation_complete_1, options=options,\n).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_easing/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\n\n\nclass EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=50, duration=DURATION, delay=DELAY,\n        easing=options[\'easing\'],\n    ).animation_complete(\n        on_animation_complete_2, options=options,\n    ).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=100, duration=DURATION, delay=DELAY,\n        easing=options[\'easing\'],\n    ).animation_complete(\n        on_animation_complete_1, options=options,\n    ).start()\n\n\noptions: EasingOptions = {\'easing\': ap.Easing.EASE_IN_QUINT}\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY,\n    easing=options[\'easing\'],\n).animation_complete(\n    on_animation_complete_1, options=options,\n).start()\n\noptions = {\'easing\': ap.Easing.EASE_OUT_QUINT}\nsprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY,\n    easing=options[\'easing\'],\n).animation_complete(\n    on_animation_complete_1, options=options,\n).start()\n\noptions = {\'easing\': ap.Easing.EASE_IN_OUT_QUINT}\nsprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY,\n    easing=options[\'easing\'],\n).animation_complete(\n    on_animation_complete_1, options=options,\n).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_easing/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## X animation':
    '## X座標のアニメーション',

    'The `animation_x` interface sets the x-coordinate animation. For more details:':  # noqa
    '`animation_x`のインターフェイスではX座標のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_x interface document](animation_x.md)':
    '- [animation_x （X座標のアニメーション）のインターフェイス](jp_animation_x.md)',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_x/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_x(\n        x=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_x(\n    x=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_x/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Y animation':
    '## Y座標のアニメーション',

    'The `animation_y` interface sets the y-coordinate animation. For more details:':  # noqa
    '`animation_y`インターフェイスではY座標のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_y interface document](animation_y.md)':
    '- [animation_y （Y座標のアニメーション）のインターフェイス](jp_animation_y.md)',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_y(\n    y=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_y/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_y(\n        y=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_y(\n    y=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_y/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Move animation':
    '## X座標とY座標のアニメーション',

    'The `animation_move` interface sets the x- and y-coordinates animation. For more details:':  # noqa
    '`animation_move`のインターフェイスはX座標とY座標両方のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_move interface document](animation_move.md)':
    '- [animation_move （XとY座標のアニメーション）のインターフェイス](jp_animation_move.md)',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=50, y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=100, y=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_move(\n    x=100, y=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_move/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=50, y=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_move(\n        x=100, y=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_move(\n    x=100, y=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_move/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Width animation':
    '## 幅のアニメーション',

    'The `animation_width` interface sets the width animation. For more details:':  # noqa
    '`animation_width`インターフェイスは幅のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_width and animation_height interfaces document](animation_width_and_height.md)':  # noqa
    '- [animation_width （幅のアニメーション）と animation_height （高さのアニメーション）のインターフェイス](jp_animation_width_and_height.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_width(\n    width=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_width/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_width(\n        width=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_width(\n    width=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_width/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Height animation':
    '## 高さのアニメーション',

    'The `animation_height` interface sets the height animation. For more details:':  # noqa
    '`animation_height`インターフェイスは高さのアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_width and animation_height interfaces document](animation_width_and_height.md)':  # noqa
    '- [animation_width （幅のアニメーション）と animation_height （高さのアニメーション）のインターフェイス](jp_animation_width_and_height.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_height(\n    height=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_height/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_height(\n        height=100, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_height(\n    height=100, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_height/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Fill color animation':
    '## 塗りの色のアニメーション',

    'The `animation_fill_color` interface sets the fill color animation. For more details:':  # noqa
    '`animation_fill_color`インターフェイスは塗りの色のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_fill_color interface document](animation_fill_color.md)':
    '- [animation_fill_color （塗りの色のアニメーション）のインターフェイス](jp_animation_fill_color.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#0af\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_fill_color(\n    fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_fill_color/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#0af\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_color(\n        fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_fill_color(\n    fill_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_fill_color/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Fill alpha animation':
    '## 塗りの透明度のアニメーション',

    'The `animation_fill_alpha` interface sets the alpha (opacity) animation. For more details:':  # noqa
    '`animation_fill_alpha`インターフェイスは塗りの透明度のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_fill_alpha interface document](animation_fill_alpha.md)':
    '- [animation_fill_alpha （塗りの透明度のアニメーション）のインターフェイス](jp_animation_fill_alpha.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_fill_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_fill_alpha/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_fill_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_fill_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_fill_alpha/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Line-color animation':
    '## 線色のアニメーション',

    'The `animation_line_color` interface sets the line color animation. For more details:':  # noqa
    '`animation_line_color`インターフェイスは線色のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_line_color interface document](animation_line_color.md)':
    '- [animation_line_color （線色のアニメーション）のインターフェイス](jp_animation_line_color.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.line_style(color=\'#0af\', thickness=5)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#0af\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_line_color(\n    line_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_line_color/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.line_style(color=\'#0af\', thickness=5)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#0af\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_color(\n        line_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_line_color(\n    line_color=\'#f0a\', duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_line_color/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Line alpha animation':
    '## 線の透明度のアニメーション',

    'The `animation_line_alpha` interface sets the line alpha (opacity) animation. For more details:':  # noqa
    '`animation_line_alpha`インターフェイスは線の透明度のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_line_alpha interface document](animation_line_alpha.md)':
    '- [animation_line_alpha （線の透明度のアニメーション）のインターフェイス](jp_animation_line_alpha.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.line_style(color=\'#fff\', thickness=5)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_line_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_line_alpha/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.line_style(color=\'#fff\', thickness=5)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=1.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_alpha(\n        alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_line_alpha(\n    alpha=0.0, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_line_alpha/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Line thickness animation':
    '## 線幅のアニメーション',

    'The `animation_line_thickness` interface sets the line thickness (stroke width) animation. For more details:':  # noqa
    '`animation_line_thickness`インターフェイスは線幅のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_line_thickness interface document](animation_line_thickness.md)':  # noqa
    '- [animation_line_thickness （線幅のアニメーション）のインターフェイス](jp_animation_line_thickness.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.line_style(color=\'#fff\', thickness=1)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=1, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_line_thickness(\n    thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_line_thickness/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.line_style(color=\'#fff\', thickness=1)\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=1, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_line_thickness(\n        thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_line_thickness(\n    thickness=5, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_line_thickness/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Radius animation':
    '## 半径のアニメーション',

    'The `animation_radius` interface sets the radius (for instance, circle\'s radius) animation. For more details:':  # noqa
    '`animation_radius`インターフェイスは円のインスタンスなどの半径のアニメーションを設定します。詳細は以下を参照してください:',  # noqa

    '- [animation_radius interface document](animation_radius.md)':
    '- [animation_radius （半径のアニメーション）のインターフェイス](jp_animation_radius.md)',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=25, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=75, y=75, radius=25,\n).animation_radius(\n    radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_radius/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=25, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Circle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_radius(\n        radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_circle(\n    x=75, y=75, radius=25,\n).animation_radius(\n    radius=50, duration=DURATION, delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_radius/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Rotation animation around the center point':
    '## 中央座標による回転のアニメーション',

    'The `animation_rotation_around_center` interface sets the rotation animation around the center point. For more details:':  # noqa
    '`animation_rotation_around_center`インターフェイスは中央座標による回転のアニメーションを設定します。詳細は以下を参照してください:',  # noqa

    '- [animation_rotation_around_center interface document](animation_rotation_around_center.md)':  # noqa
    '- [animation_rotation_around_center （中央座標での回転のアニメーション）のインターフェイス](jp_animation_rotation_around_center.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=90, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_rotation_around_center(\n    rotation_around_center=90, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_rotation_around_center/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_center(\n        rotation_around_center=90, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_rotation_around_center(\n    rotation_around_center=90, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_rotation_around_center/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Rotation animation around the specified point':
    '## 指定座標による回転のアニメーション',

    'The `animation_rotation_around_point` interface sets the rotation animation around the specified point. For more details:':  # noqa
    '`animation_rotation_around_point`',

    '- [animation_rotation_around_point interface document](animation_rotation_around_point.md)':  # noqa
    '- [animation_rotation_around_point （指定座標による回転のアニメーション）のインターフェイス](jp_animation_rotation_around_point.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=0, x=100, y=100, duration=DURATION,\n        delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=90, x=100, y=100, duration=DURATION,\n        delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_rotation_around_point(\n    rotation_around_point=90, x=100, y=100, duration=DURATION,\n    delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_rotation_around_point/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=200, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=0, x=100, y=100, duration=DURATION,\n        delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_rotation_around_point(\n        rotation_around_point=90, x=100, y=100, duration=DURATION,\n        delay=DELAY, easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_rotation_around_point(\n    rotation_around_point=90, x=100, y=100, duration=DURATION,\n    delay=DELAY, easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_rotation_around_point/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Scale-x animation from the center point':
    '## 中央座標による水平方向の拡縮のアニメーション',

    'The `animation_scale_x_from_center` interface sets the scale-x animation from the center point. For more details:':  # noqa
    '`animation_scale_x_from_center`インターフェイスは中央座標による水平方向の拡縮のアニメーションを設定します。詳細は以下を参照してください:',  # noqa

    '- [animation_scale_x_from_center and animation_scale_y_from_center interfaces document](animation_scale_x_and_y_from_center.md)':  # noqa
    '- [animation_scale_x_from_center （中央座標による水平方向の拡縮アニメーション）と animation_scale_y_from_center （中央座標による垂直方向の拡縮アニメーション）のインターフェイス](jp_animation_scale_x_and_y_from_center.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_x_from_center(\n    scale_x_from_center=0.5, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_x_from_center/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_center(\n        scale_x_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_x_from_center(\n    scale_x_from_center=0.5, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_x_from_center/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Scale-y animation from the center point':
    '## 中央座標による垂直方向の拡縮のアニメーション',

    'The `animation_scale_y_from_center` interface sets the scale-y animation from the center point. For more details:':  # noqa
    '`animation_scale_y_from_center`インターフェイスは中央座標による垂直方向のアニメーションを設定します。詳細は以下を参照してください:',  # noqa

    '- [animation_scale_x_from_center and animation_scale_y_from_center interfaces document](animation_scale_x_and_y_from_center.md)':  # noqa
    '- [animation_scale_x_from_center （中央座標による水平方向の拡縮アニメーション）と animation_scale_y_from_center （中央座標による垂直方向の拡縮アニメーション）のインターフェイス](jp_animation_scale_x_and_y_from_center.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_y_from_center(\n    scale_y_from_center=0.5, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_y_from_center/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=1.0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_center(\n        scale_y_from_center=0.5, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_y_from_center(\n    scale_y_from_center=0.5, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_y_from_center/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Scale-x animation from the specified point':
    '## 指定座標による水平方向の拡縮アニメーション',

    'The `animation_scale_x_from_point` interface sets the scale-x animation from the specified point. For more details:':  # noqa
    '`animation_scale_x_from_point`インターフェイスは指定座標による水平方向の拡縮のアニメーションを設定します。詳細は以下を参照してください:',  # noqa

    '- [animation_scale_x_from_point and animation_scale_y_from_point interfaces document](animation_scale_x_and_y_from_point.md)':  # noqa
    '- [animation_scale_x_from_point （指定座標による水平方向の拡縮アニメーション）と animation_scale_y_from_point （指定座標による垂直方向のアニメーション）のインターフェイス](jp_animation_scale_x_and_y_from_point.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=1.0, x=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=0.5, x=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_x_from_point(\n    scale_x_from_point=0.5, x=100, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_x_from_point/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=1.0, x=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_x_from_point(\n        scale_x_from_point=0.5, x=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_x_from_point(\n    scale_x_from_point=0.5, x=100, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_x_from_point/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Scale-y animation from the specified point':
    '## 指定座標による垂直方向の拡縮アニメーション',

    'The `animation_scale_y_from_point` interface sets the scale-y animation from the specified point. For more details:':  # noqa
    '`animation_scale_y_from_point`インターフェイスは指定座標による垂直方向の拡縮アニメーションを設定します。詳細は以下を参照してください:',  # noqa

    '- [animation_scale_x_from_point and animation_scale_y_from_point interfaces document](animation_scale_x_and_y_from_point.md)':  # noqa
    '- [animation_scale_x_from_point （指定座標による水平方向の拡縮アニメーション）と animation_scale_y_from_point （指定座標による垂直方向のアニメーション）のインターフェイス](jp_animation_scale_x_and_y_from_point.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=1.0, y=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=0.5, y=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_y_from_point(\n    scale_y_from_point=0.5, y=100, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_y_from_point/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=1.0, y=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_scale_y_from_point(\n        scale_y_from_point=0.5, y=100, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_scale_y_from_point(\n    scale_y_from_point=0.5, y=100, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_scale_y_from_point/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Skew-x animation':
    '## 水平方向の斜め変換のアニメーション',

    'The `animation_skew_x` interface sets the skew-x animation. For more details:':  # noqa
    '`animation_skew_x`インターフェイスは水平方向の斜め変換のアニメーションを設定します。詳細は以下を参照してください:',

    '- [animation_skew_x interface document](animation_skew_x.md)':
    '- [animation_skew_x （水平方向の斜め変換のアニメーション）のインターフェイス](jp_animation_skew_x.md)',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=50, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_skew_x(\n    skew_x=50, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_skew_x/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\nap.Stage(\n    stage_width=150, stage_height=150, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\n\nDURATION: int = 1000\nDELAY: int = 500\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=0, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_2).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    e.this.target.animation_skew_x(\n        skew_x=50, duration=DURATION, delay=DELAY,\n        easing=EASING,\n    ).animation_complete(on_animation_complete_1).start()\n\n\nsprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50,\n).animation_skew_x(\n    skew_x=50, duration=DURATION, delay=DELAY,\n    easing=EASING,\n).animation_complete(on_animation_complete_1).start()\n\nap.save_overall_html(\n    dest_dir_path=\'animation_interfaces_abstract_skew_x/\')\n```',  # noqa

    '</details>':
    '</details>',

}
