"""This module is for the translation mapping data of the
following document:

Document file: animation_scale_x_and_y_from_point.md
Language: jp
"""

from typing import Dict

MAPPING: Dict[str, str] = {

    '# animation_scale_x_from_point and animation_scale_y_from_point interfaces':  # noqa
    '# animation_scale_x_from_point と animation_scale_y_from_point のインターフェイス',  # noqa

    'This page explains the `animation_scale_x_from_point` and `animation_scale_y_from_point` method interfaces.':  # noqa
    'このページでは`animation_scale_x_from_point`と`animation_scale_y_from_point`の各メソッドのインターフェイスについて説明します。',  # noqa

    '## What interfaces are these?':
    '## 各インターフェイスの概要',

    'The `animation_scale_x_from_point` method interface will create an `ap.AnimationScaleXFromPoint` instance. You can animate the x-directional scale with it from a specified x-coordinate.':  # noqa
    '`animation_scale_x_from_point`メソッドのインターフェイスは`ap.AnimationScaleXFromPoint`クラスのインスタンスを生成します。そのインスタンスを使って指定座標を基準としたX軸の拡縮のアニメーションを設定することができます。',  # noqa

    'Similarly, the `animation_scale_y_from_point` method interface creates an `ap.AnimationScaleYFromPoint` instance. You can animate the y-directional scale with it from a specified y-coordinate.':  # noqa
    '同じように`animation_scale_y_from_point`メソッドのインターフェイスでは`ap.AnimationScaleYFromPoint`クラスのインスタンスを生成します。そのインスタンスを使ってY軸の拡縮のアニメーションを設定することができます。',  # noqa

    'These interfaces exist on a `GraphicsBase` subclass (that has the `scale_x_from_center` and `scale_y_from_center` interfaces), such as the `Rectangle` or `Circle`.':  # noqa
    'これらのインターフェイスは`scale_x_from_center`や`scale_y_from_center`などのインターフェイスを持つ`Rectangle`や`Circle`などの`GraphicsBase`の各サブクラス上に存在します。',  # noqa

    '## Basic usage':
    '## 基本的な使い方',

    'The following example sets the x-directional scale (left-side rectangle) and y-directional scale (right-side rectangle) animation (from 1.0 to 2.0) with the `animation_scale_x_from_point` and `animation_scale_y_from_point` methods.':  # noqa
    '以下のコード例ではX軸の拡縮（1.0から2.0）を左側の四角へ、そしてY軸の拡縮を右側の四角へとそれぞれ`animation_scale_x_from_point`と`animation_scale_y_from_point`のメソッドを使って設定しています。',  # noqa

    'These settings set the left-side rectangle scales from the left end (x=50) and the right-side rectangle scales from the bottom end (y=100).':  # noqa
    'これらの設定は左側の四角では左端（x=50）の座標で、右側の四角では下端（y=100）の位置を基準に拡縮の設定を行っています。',

    '```py\n# runnable\nfrom enum import Enum\n\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\nDURATION: int = 1000\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\nLEFT_RECTANGLE_X: int = 50\nRIGHT_RECTANGLE_Y: int = 100\nSCALE_1: float = 1.0\nSCALE_2: float = 2.0\n\n\nclass Direction(Enum):\n    X = 1\n    Y = 2\n\n\nclass Options(TypedDict):\n    direction: Direction\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: Options) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    rectangle: ap.Rectangle = e.this.target\n    if options[\'direction\'] == Direction.X:\n        rectangle.animation_scale_x_from_point(\n            scale_x_from_point=SCALE_1,\n            x=LEFT_RECTANGLE_X,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_2,\n            options=options,\n        ).start()\n    elif options[\'direction\'] == Direction.Y:\n        rectangle.animation_scale_y_from_point(\n            scale_y_from_point=SCALE_1,\n            y=RIGHT_RECTANGLE_Y,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_2,\n            options=options,\n        ).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: Options) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    rectangle: ap.Rectangle = e.this.target\n    if options[\'direction\'] == Direction.X:\n        rectangle.animation_scale_x_from_point(\n            scale_x_from_point=SCALE_2,\n            x=LEFT_RECTANGLE_X,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_1,\n            options=options,\n        ).start()\n    elif options[\'direction\'] == Direction.Y:\n        rectangle.animation_scale_y_from_point(\n            scale_y_from_point=SCALE_2,\n            y=RIGHT_RECTANGLE_Y,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_1,\n            options=options,\n        ).start()\n\n\nap.Stage(\n    stage_width=250, stage_height=150,\n    background_color=\'#333\', stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nleft_rectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nright_rectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=150, y=50, width=50, height=50)\n\noptions: Options = {\'direction\': Direction.X}\nleft_rectangle.animation_scale_x_from_point(\n    scale_x_from_point=SCALE_2,\n    x=LEFT_RECTANGLE_X,\n    duration=DURATION,\n    easing=EASING,\n).animation_complete(\n    on_animation_complete_1,\n    options=options,\n).start()\n\noptions = {\'direction\': Direction.Y}\nright_rectangle.animation_scale_y_from_point(\n    scale_y_from_point=SCALE_2,\n    y=RIGHT_RECTANGLE_Y,\n    duration=DURATION,\n    easing=EASING,\n).animation_complete(\n    on_animation_complete_1,\n    options=options,\n).start()\n\nap.save_overall_html(\n    dest_dir_path=\'./animation_scale_x_and_y_from_point_basic_usage/\')\n```':  # noqa
    '```py\n# runnable\nfrom enum import Enum\n\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\nDURATION: int = 1000\nEASING: ap.Easing = ap.Easing.EASE_OUT_QUINT\nLEFT_RECTANGLE_X: int = 50\nRIGHT_RECTANGLE_Y: int = 100\nSCALE_1: float = 1.0\nSCALE_2: float = 2.0\n\n\nclass Direction(Enum):\n    X = 1\n    Y = 2\n\n\nclass Options(TypedDict):\n    direction: Direction\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle], options: Options) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    rectangle: ap.Rectangle = e.this.target\n    if options[\'direction\'] == Direction.X:\n        rectangle.animation_scale_x_from_point(\n            scale_x_from_point=SCALE_1,\n            x=LEFT_RECTANGLE_X,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_2,\n            options=options,\n        ).start()\n    elif options[\'direction\'] == Direction.Y:\n        rectangle.animation_scale_y_from_point(\n            scale_y_from_point=SCALE_1,\n            y=RIGHT_RECTANGLE_Y,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_2,\n            options=options,\n        ).start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle], options: Options) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    rectangle: ap.Rectangle = e.this.target\n    if options[\'direction\'] == Direction.X:\n        rectangle.animation_scale_x_from_point(\n            scale_x_from_point=SCALE_2,\n            x=LEFT_RECTANGLE_X,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_1,\n            options=options,\n        ).start()\n    elif options[\'direction\'] == Direction.Y:\n        rectangle.animation_scale_y_from_point(\n            scale_y_from_point=SCALE_2,\n            y=RIGHT_RECTANGLE_Y,\n            duration=DURATION,\n            easing=EASING,\n        ).animation_complete(\n            on_animation_complete_1,\n            options=options,\n        ).start()\n\n\nap.Stage(\n    stage_width=250, stage_height=150,\n    background_color=\'#333\', stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nleft_rectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nright_rectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=150, y=50, width=50, height=50)\n\noptions: Options = {\'direction\': Direction.X}\nleft_rectangle.animation_scale_x_from_point(\n    scale_x_from_point=SCALE_2,\n    x=LEFT_RECTANGLE_X,\n    duration=DURATION,\n    easing=EASING,\n).animation_complete(\n    on_animation_complete_1,\n    options=options,\n).start()\n\noptions = {\'direction\': Direction.Y}\nright_rectangle.animation_scale_y_from_point(\n    scale_y_from_point=SCALE_2,\n    y=RIGHT_RECTANGLE_Y,\n    duration=DURATION,\n    easing=EASING,\n).animation_complete(\n    on_animation_complete_1,\n    options=options,\n).start()\n\nap.save_overall_html(\n    dest_dir_path=\'./animation_scale_x_and_y_from_point_basic_usage/\')\n```',  # noqa

}
