"""This module is for the translation mapping data of the
following document:

Document file: easing_enum.md
Language: jp
"""

from typing import Dict

MAPPING: Dict[str, str] = {

    '# Easing enum':
    '# イージングのenum',

    'This page explains the `Easing` enum class.':
    'このページでは`Easing`のenumのクラスについて説明します。',

    '## What class is this?':
    '## クラス概要',

    'The `Easing` enum class defines each easing function. These are used at the animation interfaces, for example, the `animation_move` interface.':  # noqa
    '`Easing`のenumのクラスは各イージング関数について定義しています。これらは`animation_move`などのアニメーションのインターフェイスで使用します。',  # noqa

    '## Basic usage':
    '## 基本的な使い方',

    'Each animation method interface, such as the `animation_move`\\, `animation_x`\\, has the `easing` argument. You can specify any of the `Easing` enums, as follows:':  # noqa
    '`animation_move`や`animation_x`などの各アニメーションのメソッドのインターフェイスでは`easing`引数を持っており、以下のコード例のようにその引数に`Easing`のenumの値を指定することができます:',  # noqa

    '```py\n# runnable\nimport apysc as ap\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=50, y=50, duration=1000, easing=ap.Easing.EASE_OUT_QUINT)\n    animation_move.animation_complete(on_animation_complete_2)\n    animation_move.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=100, y=100, duration=1000, easing=ap.Easing.EASE_OUT_QUINT)\n    animation_move.animation_complete(on_animation_complete_1)\n    animation_move.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\n\nanimation_move: ap.AnimationMove = rectangle.animation_move(\n    x=100, y=100, duration=1000, easing=ap.Easing.EASE_OUT_QUINT)\nanimation_move.animation_complete(on_animation_complete_1)\nanimation_move.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_basic_usage/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=50, y=50, duration=1000, easing=ap.Easing.EASE_OUT_QUINT)\n    animation_move.animation_complete(on_animation_complete_2)\n    animation_move.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=100, y=100, duration=1000, easing=ap.Easing.EASE_OUT_QUINT)\n    animation_move.animation_complete(on_animation_complete_1)\n    animation_move.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\n\nanimation_move: ap.AnimationMove = rectangle.animation_move(\n    x=100, y=100, duration=1000, easing=ap.Easing.EASE_OUT_QUINT)\nanimation_move.animation_complete(on_animation_complete_1)\nanimation_move.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_basic_usage/\')\n```',  # noqa

    'If you skip the specification of the `easing` argument, the animation becomes a linear one:':  # noqa
    'もしも`easing`引数の指定を省略した場合、アニメーションは線形（スタートから終了まで一定の変動）のアニメーションとなります。',

    '```py\n# runnable\nimport apysc as ap\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=50, y=50, duration=1000)\n    animation_move.animation_complete(on_animation_complete_2)\n    animation_move.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=100, y=100, duration=1000)\n    animation_move.animation_complete(on_animation_complete_1)\n    animation_move.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\n\nanimation_move: ap.AnimationMove = rectangle.animation_move(\n    x=100, y=100, duration=1000)\nanimation_move.animation_complete(on_animation_complete_1)\nanimation_move.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_default_setting/\')\n```':  # noqa
    '```py\n# runnable\nimport apysc as ap\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=50, y=50, duration=1000)\n    animation_move.animation_complete(on_animation_complete_2)\n    animation_move.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: dict) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_move: ap.AnimationMove = e.this.target.animation_move(\n        x=100, y=100, duration=1000)\n    animation_move.animation_complete(on_animation_complete_1)\n    animation_move.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=200, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\n\nanimation_move: ap.AnimationMove = rectangle.animation_move(\n    x=100, y=100, duration=1000)\nanimation_move.animation_complete(on_animation_complete_1)\nanimation_move.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_default_setting/\')\n```',  # noqa

    '## What difference between the ease-in, ease-out, and ease-in-out':
    '## イーズイン（ease-in）、イーズアウト（ease-out）、イーズインアウト（ease-in-out）の違い',

    '- Ease-in starts with slow speed and stops with fast speed.':
    '- イーズイン（ease-in）は最初は遅くスタートし、最後の方で速いアニメーションになります。',

    '- Ease-out starts with fast speed and stops with slow speed.':
    '- イーズアウト（ease-out）は最初は速いスピードでスタートし、最後の方で遅いアニメーションになります。',

    '- Ease-in-out starts and stops with slow speed, and it gets faster on the way.':  # noqa
    '- イーズインアウト（ease-in-out）は最初と最後の両方が遅いスピードとなり、中間で一番速いアニメーションとなります。',

    'The following example shows the difference between the `EASE_IN_QUINT`\\, `EASE_OUT_QUINT`\\, and `EASE_IN_OUT_QUINT`\\.':  # noqa
    '以下のコード例では差が分かるように`EASE_IN_QUINT`、`EASE_OUT_QUINT`、`EASE_IN_OUT_QUINT`のそれぞれを表示しています。',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_QUINT\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_IN_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_difference/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_QUINT\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_IN_OUT_QUINT\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_difference/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Ease-in examples':
    '## イーズインの例',

    'This section shows each ease-in setting result with the x-coordinate animation.':  # noqa
    'この節ではX座標のアニメーションにおける各イーズインの設定による例を表示しています。',

    'The following is the example of the `EASE_IN_SINE`, `EASE_IN_QUAD`, and `EASE_IN_CUBIC`:':  # noqa
    '以下のコード例では`EASE_IN_SINE`、`EASE_IN_QUAD`、`EASE_IN_CUBIC`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_SINE\nEASING_2: ap.Easing = ap.Easing.EASE_IN_QUAD\nEASING_3: ap.Easing = ap.Easing.EASE_IN_CUBIC\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_1/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_SINE\nEASING_2: ap.Easing = ap.Easing.EASE_IN_QUAD\nEASING_3: ap.Easing = ap.Easing.EASE_IN_CUBIC\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_1/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_IN_QUART`, `EASE_IN_QUINT`, and `EASE_IN_EXPO`:':  # noqa
    '以下のコード例では`EASE_IN_QUART`、`EASE_IN_QUINT`、`EASE_IN_EXPO`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_QUART\nEASING_2: ap.Easing = ap.Easing.EASE_IN_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_IN_EXPO\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_2/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_QUART\nEASING_2: ap.Easing = ap.Easing.EASE_IN_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_IN_EXPO\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_2/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_IN_CIRC` and `EASE_IN_BACK`:':  # noqa
    '以下のコード例では`EASE_IN_CIRC`と`EASE_IN_BACK`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_CIRC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_BACK\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_3/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_CIRC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_BACK\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_3/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_IN_ELASTIC` and `EASE_IN_BOUNCE`:':  # noqa
    '以下のコード例では`EASE_IN_ELASTIC`と`EASE_IN_BOUNCE`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_ELASTIC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_BOUNCE\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_4/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_ELASTIC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_BOUNCE\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_4/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Ease-out examples':
    '## イーズアウトの例',

    'This section shows each ease-out result with the x-coordinate animation.':  # noqa
    'この節ではX座標のアニメーションにおける各イーズアウトの設定による例を表示しています。',

    'The following is the example of the `EASE_OUT_SINE`, `EASE_OUT_QUAD`, and `EASE_OUT_CUBIC`:':  # noqa
    '以下のコード例では`EASE_OUT_SINE`、`EASE_OUT_QUAD`、`EASE_OUT_CUBIC`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_SINE\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_QUAD\nEASING_3: ap.Easing = ap.Easing.EASE_OUT_CUBIC\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_1/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_SINE\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_QUAD\nEASING_3: ap.Easing = ap.Easing.EASE_OUT_CUBIC\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_1/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_OUT_QUART`, `EASE_OUT_QUINT`, and `EASE_OUT_EXPO`:':  # noqa
    '以下のコード例では`EASE_OUT_QUART`, `EASE_OUT_QUINT`, `EASE_OUT_EXPO`の各値を設定しています:',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_QUART\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_OUT_EXPO\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_2/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_QUART\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_OUT_EXPO\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_2/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_OUT_CIRC` and `EASE_OUT_BACK`:':  # noqa
    '以下のコード例では`EASE_OUT_CIRC`と`EASE_OUT_BACK`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_CIRC\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_BACK\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_3/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_CIRC\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_BACK\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_3/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_OUT_ELASTIC` and `EASE_OUT_BOUNCE`:':  # noqa
    '以下のコード例では`EASE_OUT_ELASTIC`と`EASE_OUT_BOUNCE`の各値を設定しています。',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_ELASTIC\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_BOUNCE\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_4/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_OUT_ELASTIC\nEASING_2: ap.Easing = ap.Easing.EASE_OUT_BOUNCE\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_out_4/\')\n```',  # noqa

    '</details>':
    '</details>',

    '## Ease-in-out examples':
    '## イーズインアウトの例',

    'This section shows each ease-in-out setting result with the x-coordinate animation.':  # noqa
    'この節ではX座標のアニメーションにおける各イーズインアウトの設定による例を表示しています。',

    'The following is the example of the `EASE_IN_OUT_SINE`, `EASE_IN_OUT_QUAD`, and `EASE_IN_OUT_CUBIC`:':  # noqa
    '以下の例では`EASE_IN_OUT_SINE`, `EASE_IN_OUT_QUAD`, `EASE_IN_OUT_CUBIC`の各値を設定しています:',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_SINE\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_QUAD\nEASING_3: ap.Easing = ap.Easing.EASE_IN_OUT_CUBIC\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_1/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_SINE\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_QUAD\nEASING_3: ap.Easing = ap.Easing.EASE_IN_OUT_CUBIC\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_1/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_IN_OUT_QUART`, `EASE_IN_OUT_QUINT`, and `EASE_IN_OUT_EXPO`:':  # noqa
    '以下のコード例では`EASE_IN_OUT_QUART`, `EASE_IN_OUT_QUINT`, `EASE_IN_OUT_EXPO`の各値を設定しています:',  # noqa

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_QUART\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_IN_OUT_EXPO\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_2/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_QUART\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_QUINT\nEASING_3: ap.Easing = ap.Easing.EASE_IN_OUT_EXPO\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=350, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_3.animation_x(\n    x=x, duration=DURATION, easing=EASING_3)\noptions = {\'easing\': EASING_3}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_2/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_IN_OUT_CIRC` and `EASE_IN_OUT_BACK`:':  # noqa
    '以下のコード例では`EASE_IN_OUT_CIRC`と`EASE_IN_OUT_BACK`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_CIRC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_BACK\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_3/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_CIRC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_BACK\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_3/\')\n```',  # noqa

    '</details>':
    '</details>',

    'The following is the example of the `EASE_IN_OUT_ELASTIC` and `EASE_IN_OUT_BOUNCE`:':  # noqa
    '以下のコード例では`EASE_IN_OUT_ELASTIC`と`EASE_IN_OUT_BOUNCE`の各値を設定しています:',

    '<details>\n<summary>Display the code block:</summary>':
    '<details>\n<summary>コードブロックを表示:</summary>',

    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_ELASTIC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_BOUNCE\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_4/\')\n```':  # noqa
    '```py\n# runnable\nfrom typing_extensions import TypedDict\n\nimport apysc as ap\n\n\nclass _EasingOptions(TypedDict):\n    easing: ap.Easing\n\n\nDURATION: int = 1000\nEASING_1: ap.Easing = ap.Easing.EASE_IN_OUT_ELASTIC\nEASING_2: ap.Easing = ap.Easing.EASE_IN_OUT_BOUNCE\n\n\ndef on_animation_complete_1(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=50, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(on_animation_complete_2, options=options)\n    animation_x.start()\n\n\ndef on_animation_complete_2(\n        e: ap.AnimationEvent[ap.Rectangle],\n        options: _EasingOptions) -> None:\n    """\n    The handler that the animation calls when its end.\n\n    Parameters\n    ----------\n    e : ap.AnimationEvent\n        Event instance.\n    options : dict\n        Optional arguments dictionary.\n    """\n    animation_x: ap.AnimationX = e.this.target.animation_x(\n        x=100, duration=DURATION, easing=options[\'easing\'])\n    animation_x.animation_complete(\n        on_animation_complete_1, options=options)\n    animation_x.start()\n\n\nap.Stage(\n    stage_width=200, stage_height=250, background_color=\'#333\',\n    stage_elem_id=\'stage\')\nsprite: ap.Sprite = ap.Sprite()\nsprite.graphics.begin_fill(color=\'#0af\')\nrectangle_1: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=50, width=50, height=50)\nrectangle_2: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=150, width=50, height=50)\nrectangle_3: ap.Rectangle = sprite.graphics.draw_rect(\n    x=50, y=250, width=50, height=50)\n\nx: int = 100\nanimation_x: ap.AnimationX = rectangle_1.animation_x(\n    x=x, duration=DURATION, easing=EASING_1)\noptions: _EasingOptions = {\'easing\': EASING_1}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nanimation_x = rectangle_2.animation_x(\n    x=x, duration=DURATION, easing=EASING_2)\noptions = {\'easing\': EASING_2}\nanimation_x.animation_complete(on_animation_complete_1, options=options)\nanimation_x.start()\n\nap.save_overall_html(\n    dest_dir_path=\'./easing_enum_ease_in_out_4/\')\n```',  # noqa

    '</details>':
    '</details>',

}
