from decimal import Decimal
from enum import IntEnum

MULTICALL2_BYTECODE = "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"  # noqa: E501
MULTICALL3_BYTECODE = "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"  # noqa: E501


class Network(IntEnum):
    Mainnet = 1
    Gnosis = 100
    Sepolia = 11155111
    Base = 8453
    Arbitrum = 42161
    Optimism = 10
    Polygon = 137
    Tenderly = 314310
    Blast = 81457
    Filecoin = 314
    Mode = 34443
    Scroll = 534352
    Linea = 59144
    Rari = 1380012617
    Avalanche = 43114
    Hyperliquid = 999
    Unichain = 130
    Hemi = 43111
    Plume = 98866
    Plasma = 9745


MULTICALL_ADDRESSES = {
    Network.Mainnet: "0xeefBa1e63905eF1D7ACbA5a8513c70307C1cE441",
    Network.Gnosis: "0xb5b692a88BDFc81ca69dcB1d924f59f0413A602a",
}

MULTICALL2_ADDRESSES = {
    Network.Mainnet: "0x5ba1e12693dc8f9c48aad8770482f4739beed696",
    Network.Gnosis: "0x9903f30c1469d8A2f415D4E8184C93BD26992573",
}

MULTICALL3_ADDRESSES = {
    Network.Mainnet: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Gnosis: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Sepolia: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Base: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Arbitrum: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Optimism: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Polygon: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Tenderly: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Blast: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Filecoin: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Mode: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Scroll: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Linea: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Rari: "0x4c753F58Ee9E83B38170abAbBEa8B47976C7ee1b",
    Network.Avalanche: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Hyperliquid: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Unichain: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Hemi: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Plume: "0xcA11bde05977b3631167028862bE2a173976CA11",
    Network.Plasma: "0xcA11bde05977b3631167028862bE2a173976CA11",
}

CHAINS = {
    "ethereum": {
        "mainnet": Network.Mainnet,
        "sepolia": Network.Sepolia,
    },
    "gnosis": {
        "mainnet": Network.Gnosis,
    },
    "base": {
        "mainnet": Network.Base,
    },
    "arbitrum": {
        "mainnet": Network.Arbitrum,
    },
    "optimism": {
        "mainnet": Network.Optimism,
    },
    "polygon": {
        "mainnet": Network.Polygon,
    },
    "tenderly": {
        "testnet": Network.Tenderly,
    },
    "blast": {
        "mainnet": Network.Blast,
    },
    "filecoin": {
        "mainnet": Network.Filecoin,
    },
    "mode": {
        "mainnet": Network.Mode,
    },
    "scroll": {
        "mainnet": Network.Scroll,
    },
    "linea": {
        "mainnet": Network.Linea,
    },
    "rari": {
        "mainnet": Network.Rari,
    },
    "avalanche": {
        "mainnet": Network.Avalanche,
    },
    "hyperliquid": {
        "mainnet": Network.Hyperliquid,
    },
    "unichain": {
        "mainnet": Network.Unichain,
    },
    "hemi": {
        "mainnet": Network.Hemi,
    },
    "plume": {
        "mainnet": Network.Plume,
    },
    "plasma": {
        "mainnet": Network.Plasma,
    },
}

NO_STATE_OVERRIDE = [Network.Gnosis]


RAY = Decimal("1e27")

SECONDS_PER_YEAR = 31536000

NULL_ADDRESS = "0x0000000000000000000000000000000000000000"

STABLECOIN_SYMBOLS = {
    "AEUR",
    "AMAPT",
    "AUSD",
    "axlUSDC",
    "BAC",
    "BBUSD",
    "BIDR",
    "BRCP",
    "BRZ",
    "BUCK",
    "BUSD",
    "CEUR",
    "crvUSD",
    "CUSD",
    "DAI",
    "DAI+",
    "DJED",
    "DOLA",
    "DUSD",
    "EDLC",
    "ERUI",
    "ESD",
    "EURA",
    "EURC",
    "EURCV",
    "EURI",
    "EURQ",
    "EURR",
    "EURS",
    "EURt",
    "FDUSD",
    "FEI",
    "FRAX",
    "FUSD",
    "FXD",
    "GHO",
    "GUSD",
    "GYD",
    "GYEN",
    "HUSD",
    "IDRT",
    "IDRX",
    "IST",
    "JPYC",
    "JUSDT",
    "lisUSD",
    "LUSD",
    "MAI",
    "mCEUR",
    "mCUSD",
    "MIM",
    "MIMATIC",
    "MKUSD",
    "MNEE",
    "MTR",
    "MUSD",
    "MXNt",
    "ONC",
    "OUSD",
    "PAR",
    "PYUSD",
    "RLUSD",
    "RMBCASH",
    "RSV",
    "SBC",
    "SBD",
    "SCRVUSD",
    "sDAI",
    "SDAI",
    "sFRAX",
    "SUSD",
    "sUSD",
    "sUSDe",
    "sUSDS",
    "TOR",
    "TRYB",
    "TUSD",
    "USD+",
    "USD0",
    "USD1",
    "USDA",
    "USDB",
    "USDbc",
    "USDC",
    "USDC.e",
    "USDCASH",
    "USDD",
    "USDe",
    "USDf",
    "USDG",
    "USDH",
    "USDJ",
    "USDL",
    "USDN",
    "USDP",
    "USDQ",
    "USDR",
    "USDs",
    "USDS",
    "USDT",
    "USDT.e",
    "USDV",
    "USDX",
    "USDY",
    "USDZ",
    "USR",
    "wstUSR",
    "USDtb",
    "USN",
    "UST",
    "USTC",
    "USX",
    "UXD",
    "VAI",
    "vBUSD",
    "VCHF",
    "vDAI",
    "VEUR",
    "vUSDC",
    "vUSDT",
    "WANUSDT",
    "wUSDM",
    "WUSD",
    "WXDAI",
    "XCHF",
    "XDAI",
    "xDAI",
    "XIDR",
    "XSGD",
    "XSTUSD",
    "xUSD",
    "XUSD",
    "YUSD",
    "ZARP",
    "ZUSD",
    "sdeUSD",
}
