# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.client_facing_diagnosis_information import ClientFacingDiagnosisInformation
from ..types.client_facing_payor_search_response import ClientFacingPayorSearchResponse
from ..types.client_facing_payor_search_response_deprecated import ClientFacingPayorSearchResponseDeprecated
from ..types.http_validation_error import HttpValidationError
from ..types.payor_code_external_provider import PayorCodeExternalProvider

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawInsuranceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def search_get_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = None,
        provider: typing.Optional[PayorCodeExternalProvider] = None,
        provider_payor_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingPayorSearchResponse]]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingPayorSearchResponse]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/insurance/search/payor",
            method="GET",
            params={
                "insurance_name": insurance_name,
                "provider": provider,
                "provider_payor_id": provider_payor_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingPayorSearchResponse],
                    parse_obj_as(
                        type_=typing.List[ClientFacingPayorSearchResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = OMIT,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingPayorSearchResponseDeprecated]]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingPayorSearchResponseDeprecated]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/insurance/search/payor",
            method="POST",
            json={
                "insurance_name": insurance_name,
                "provider": provider,
                "provider_id": provider_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingPayorSearchResponseDeprecated],
                    parse_obj_as(
                        type_=typing.List[ClientFacingPayorSearchResponseDeprecated],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search_diagnosis(
        self, *, diagnosis_query: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ClientFacingDiagnosisInformation]]:
        """
        Parameters
        ----------
        diagnosis_query : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingDiagnosisInformation]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/insurance/search/diagnosis",
            method="GET",
            params={
                "diagnosis_query": diagnosis_query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingDiagnosisInformation],
                    parse_obj_as(
                        type_=typing.List[ClientFacingDiagnosisInformation],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawInsuranceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def search_get_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = None,
        provider: typing.Optional[PayorCodeExternalProvider] = None,
        provider_payor_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingPayorSearchResponse]]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingPayorSearchResponse]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/insurance/search/payor",
            method="GET",
            params={
                "insurance_name": insurance_name,
                "provider": provider,
                "provider_payor_id": provider_payor_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingPayorSearchResponse],
                    parse_obj_as(
                        type_=typing.List[ClientFacingPayorSearchResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = OMIT,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingPayorSearchResponseDeprecated]]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingPayorSearchResponseDeprecated]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/insurance/search/payor",
            method="POST",
            json={
                "insurance_name": insurance_name,
                "provider": provider,
                "provider_id": provider_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingPayorSearchResponseDeprecated],
                    parse_obj_as(
                        type_=typing.List[ClientFacingPayorSearchResponseDeprecated],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search_diagnosis(
        self, *, diagnosis_query: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ClientFacingDiagnosisInformation]]:
        """
        Parameters
        ----------
        diagnosis_query : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingDiagnosisInformation]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/insurance/search/diagnosis",
            method="GET",
            params={
                "diagnosis_query": diagnosis_query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingDiagnosisInformation],
                    parse_obj_as(
                        type_=typing.List[ClientFacingDiagnosisInformation],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
