# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_connection_error_details import ClientFacingConnectionErrorDetails
from .resource_availability import ResourceAvailability


class ClientFacingProviderWithStatus(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Name of source of information
    """

    slug: str = pydantic.Field()
    """
    Slug for designated source
    """

    logo: str = pydantic.Field()
    """
    URL for source logo
    """

    created_on: dt.datetime
    status: str = pydantic.Field()
    """
    Status of source, either error or connected
    """

    external_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    
    The unique identifier of the associated external data provider user.
    
    * OAuth Providers: User unique identifier; provider-specific formats
    * Password Providers: Username
    * Email Providers: Email
    * Junction Mobile SDK Providers: `null` (not available)
    """

    error_details: typing.Optional[ClientFacingConnectionErrorDetails] = pydantic.Field(default=None)
    """
    Details of the terminal connection error — populated only when the status is `error`.
    """

    resource_availability: typing.Dict[str, ResourceAvailability]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
