# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class LabTestCollectionMethod(str, enum.Enum):
    """
    The method used to perform a lab test. ℹ️ This enum is non-exhaustive.
    """

    TESTKIT = "testkit"
    WALK_IN_TEST = "walk_in_test"
    AT_HOME_PHLEBOTOMY = "at_home_phlebotomy"
    ON_SITE_COLLECTION = "on_site_collection"
    _UNKNOWN = "__LABTESTCOLLECTIONMETHOD_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "LabTestCollectionMethod":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        testkit: typing.Callable[[], T_Result],
        walk_in_test: typing.Callable[[], T_Result],
        at_home_phlebotomy: typing.Callable[[], T_Result],
        on_site_collection: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is LabTestCollectionMethod.TESTKIT:
            return testkit()
        if self is LabTestCollectionMethod.WALK_IN_TEST:
            return walk_in_test()
        if self is LabTestCollectionMethod.AT_HOME_PHLEBOTOMY:
            return at_home_phlebotomy()
        if self is LabTestCollectionMethod.ON_SITE_COLLECTION:
            return on_site_collection()
        return _unknown_member(self._value_)
