# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ProviderLinkResponseErrorType(str, enum.Enum):
    INVALID_TOKEN = "invalid_token"
    TOKEN_EXPIRED = "token_expired"
    TOKEN_NOT_VALIDATED = "token_not_validated"
    TOKEN_CONSUMED = "token_consumed"
    PROVIDER_CREDENTIAL_ERROR = "provider_credential_error"
    PROVIDER_PASSWORD_EXPIRED = "provider_password_expired"
    PROVIDER_API_ERROR = "provider_api_error"
    UNSUPPORTED_REGION = "unsupported_region"
    DUPLICATE_CONNECTION = "duplicate_connection"
    REQUIRED_SCOPES_NOT_GRANTED = "required_scopes_not_granted"
    INCORRECT_MFA_CODE = "incorrect_mfa_code"
    USER_CANCELLED = "user_cancelled"
    _UNKNOWN = "__PROVIDERLINKRESPONSEERRORTYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ProviderLinkResponseErrorType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        invalid_token: typing.Callable[[], T_Result],
        token_expired: typing.Callable[[], T_Result],
        token_not_validated: typing.Callable[[], T_Result],
        token_consumed: typing.Callable[[], T_Result],
        provider_credential_error: typing.Callable[[], T_Result],
        provider_password_expired: typing.Callable[[], T_Result],
        provider_api_error: typing.Callable[[], T_Result],
        unsupported_region: typing.Callable[[], T_Result],
        duplicate_connection: typing.Callable[[], T_Result],
        required_scopes_not_granted: typing.Callable[[], T_Result],
        incorrect_mfa_code: typing.Callable[[], T_Result],
        user_cancelled: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ProviderLinkResponseErrorType.INVALID_TOKEN:
            return invalid_token()
        if self is ProviderLinkResponseErrorType.TOKEN_EXPIRED:
            return token_expired()
        if self is ProviderLinkResponseErrorType.TOKEN_NOT_VALIDATED:
            return token_not_validated()
        if self is ProviderLinkResponseErrorType.TOKEN_CONSUMED:
            return token_consumed()
        if self is ProviderLinkResponseErrorType.PROVIDER_CREDENTIAL_ERROR:
            return provider_credential_error()
        if self is ProviderLinkResponseErrorType.PROVIDER_PASSWORD_EXPIRED:
            return provider_password_expired()
        if self is ProviderLinkResponseErrorType.PROVIDER_API_ERROR:
            return provider_api_error()
        if self is ProviderLinkResponseErrorType.UNSUPPORTED_REGION:
            return unsupported_region()
        if self is ProviderLinkResponseErrorType.DUPLICATE_CONNECTION:
            return duplicate_connection()
        if self is ProviderLinkResponseErrorType.REQUIRED_SCOPES_NOT_GRANTED:
            return required_scopes_not_granted()
        if self is ProviderLinkResponseErrorType.INCORRECT_MFA_CODE:
            return incorrect_mfa_code()
        if self is ProviderLinkResponseErrorType.USER_CANCELLED:
            return user_cancelled()
        return _unknown_member(self._value_)
