# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.drive_agent_response import DriveAgentResponse
from .raw_client import AsyncRawDriveClient, RawDriveClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DriveClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDriveClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDriveClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDriveClient
        """
        return self._raw_client

    def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DriveAgentResponse:
        """
        Coming soon! Manage folders and search for files in the internal drive.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the drive agent including folder paths and search parameters

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the drive agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DriveAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.drive.invoke(
            config={"key": "value"},
            messages=[{"key": "value"}],
        )
        """
        _response = self._raw_client.invoke(config=config, messages=messages, request_options=request_options)
        return _response.data


class AsyncDriveClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDriveClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDriveClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDriveClient
        """
        return self._raw_client

    async def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DriveAgentResponse:
        """
        Coming soon! Manage folders and search for files in the internal drive.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the drive agent including folder paths and search parameters

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the drive agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DriveAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.drive.invoke(
                config={"key": "value"},
                messages=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke(config=config, messages=messages, request_options=request_options)
        return _response.data
