# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.research_agent_response import ResearchAgentResponse
from .raw_client import AsyncRawResearchClient, RawResearchClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ResearchClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawResearchClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawResearchClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawResearchClient
        """
        return self._raw_client

    def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResearchAgentResponse:
        """
        Coming soon! Conduct research using web and other sources.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the research agent including search parameters and sources

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the research agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResearchAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.research.invoke(
            config={"key": "value"},
            messages=[{"key": "value"}],
        )
        """
        _response = self._raw_client.invoke(config=config, messages=messages, request_options=request_options)
        return _response.data


class AsyncResearchClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawResearchClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawResearchClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawResearchClient
        """
        return self._raw_client

    async def invoke(
        self,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResearchAgentResponse:
        """
        Coming soon! Conduct research using web and other sources.

        Parameters
        ----------
        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the research agent including search parameters and sources

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the research agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResearchAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.research.invoke(
                config={"key": "value"},
                messages=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke(config=config, messages=messages, request_options=request_options)
        return _response.data
