# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.aop_async_execute_response_out import AopAsyncExecuteResponseOut
from ..types.aop_execute_request_in import AopExecuteRequestIn
from ..types.aop_execute_response_out import AopExecuteResponseOut
from .raw_client import AsyncRawAopClient, RawAopClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AopClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAopClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAopClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAopClient
        """
        return self._raw_client

    def execute(
        self, *, request: AopExecuteRequestIn, request_options: typing.Optional[RequestOptions] = None
    ) -> AopExecuteResponseOut:
        """
        Execute an existing Agent Operating Procedure (AOP) asset with optional user inputs. AOPs are pre-configured AI workflows that can perform complex tasks like research, analysis, and content generation.

        Parameters
        ----------
        request : AopExecuteRequestIn

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AopExecuteResponseOut
            AOP execution started successfully

        Examples
        --------
        from athena import AopExecuteRequestIn, Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.aop.execute(
            request=AopExecuteRequestIn(
                asset_id="asset_9249292-d118-42d3-95b4-00eccfe0754f",
                user_inputs={"company": "Acme Corp", "quarter": "Q1 2024"},
            ),
        )
        """
        _response = self._raw_client.execute(request=request, request_options=request_options)
        return _response.data

    def execute_async(
        self, *, request: AopExecuteRequestIn, request_options: typing.Optional[RequestOptions] = None
    ) -> AopAsyncExecuteResponseOut:
        """
        Start execution of an Agent Operating Procedure (AOP) asset asynchronously. Returns immediately with a thread_id for tracking execution progress without waiting for completion.

        Parameters
        ----------
        request : AopExecuteRequestIn

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AopAsyncExecuteResponseOut
            AOP execution started successfully

        Examples
        --------
        from athena import AopExecuteRequestIn, Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.aop.execute_async(
            request=AopExecuteRequestIn(
                asset_id="asset_9249292-d118-42d3-95b4-00eccfe0754f",
                user_inputs={"company": "Acme Corp", "quarter": "Q1 2024"},
            ),
        )
        """
        _response = self._raw_client.execute_async(request=request, request_options=request_options)
        return _response.data


class AsyncAopClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAopClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAopClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAopClient
        """
        return self._raw_client

    async def execute(
        self, *, request: AopExecuteRequestIn, request_options: typing.Optional[RequestOptions] = None
    ) -> AopExecuteResponseOut:
        """
        Execute an existing Agent Operating Procedure (AOP) asset with optional user inputs. AOPs are pre-configured AI workflows that can perform complex tasks like research, analysis, and content generation.

        Parameters
        ----------
        request : AopExecuteRequestIn

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AopExecuteResponseOut
            AOP execution started successfully

        Examples
        --------
        import asyncio

        from athena import AopExecuteRequestIn, AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.aop.execute(
                request=AopExecuteRequestIn(
                    asset_id="asset_9249292-d118-42d3-95b4-00eccfe0754f",
                    user_inputs={"company": "Acme Corp", "quarter": "Q1 2024"},
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute(request=request, request_options=request_options)
        return _response.data

    async def execute_async(
        self, *, request: AopExecuteRequestIn, request_options: typing.Optional[RequestOptions] = None
    ) -> AopAsyncExecuteResponseOut:
        """
        Start execution of an Agent Operating Procedure (AOP) asset asynchronously. Returns immediately with a thread_id for tracking execution progress without waiting for completion.

        Parameters
        ----------
        request : AopExecuteRequestIn

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AopAsyncExecuteResponseOut
            AOP execution started successfully

        Examples
        --------
        import asyncio

        from athena import AopExecuteRequestIn, AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.aop.execute_async(
                request=AopExecuteRequestIn(
                    asset_id="asset_9249292-d118-42d3-95b4-00eccfe0754f",
                    user_inputs={"company": "Acme Corp", "quarter": "Q1 2024"},
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_async(request=request, request_options=request_options)
        return _response.data
