# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.data_frame_request_out import DataFrameRequestOut
from .raw_client import AsyncRawQueryClient, RawQueryClient
from .types.query_execute_request_database_asset_ids import QueryExecuteRequestDatabaseAssetIds


class QueryClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawQueryClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawQueryClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawQueryClient
        """
        return self._raw_client

    def execute(
        self,
        *,
        sql_command: str,
        database_asset_ids: QueryExecuteRequestDatabaseAssetIds,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataFrameRequestOut:
        """
        Get the result of an SQL query over given assets.

        Parameters
        ----------
        sql_command : str
            SQL query string

        database_asset_ids : QueryExecuteRequestDatabaseAssetIds
            Single ID or list of asset IDs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataFrameRequestOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.query.execute(
            sql_command="sql_command",
            database_asset_ids="database_asset_ids",
        )
        """
        _response = self._raw_client.execute(
            sql_command=sql_command, database_asset_ids=database_asset_ids, request_options=request_options
        )
        return _response.data

    def execute_snippet(
        self, *, snippet_asset_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DataFrameRequestOut:
        """
        Get the result of an SQL query over given assets.

        Parameters
        ----------
        snippet_asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataFrameRequestOut
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.query.execute_snippet(
            snippet_asset_id="snippet_asset_id",
        )
        """
        _response = self._raw_client.execute_snippet(snippet_asset_id=snippet_asset_id, request_options=request_options)
        return _response.data


class AsyncQueryClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawQueryClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawQueryClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawQueryClient
        """
        return self._raw_client

    async def execute(
        self,
        *,
        sql_command: str,
        database_asset_ids: QueryExecuteRequestDatabaseAssetIds,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataFrameRequestOut:
        """
        Get the result of an SQL query over given assets.

        Parameters
        ----------
        sql_command : str
            SQL query string

        database_asset_ids : QueryExecuteRequestDatabaseAssetIds
            Single ID or list of asset IDs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataFrameRequestOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.query.execute(
                sql_command="sql_command",
                database_asset_ids="database_asset_ids",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute(
            sql_command=sql_command, database_asset_ids=database_asset_ids, request_options=request_options
        )
        return _response.data

    async def execute_snippet(
        self, *, snippet_asset_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DataFrameRequestOut:
        """
        Get the result of an SQL query over given assets.

        Parameters
        ----------
        snippet_asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataFrameRequestOut
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.query.execute_snippet(
                snippet_asset_id="snippet_asset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_snippet(
            snippet_asset_id=snippet_asset_id, request_options=request_options
        )
        return _response.data
