# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AopExecuteRequestIn(UniversalBaseModel):
    """
    Request model for executing an AOP (Agent Operating Procedure).
    """

    asset_id: str = pydantic.Field()
    """
    ID of the existing AOP asset to execute
    """

    user_inputs: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Optional user inputs to append to the AOP's prompt as key-value pairs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
