# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .general_agent_config import GeneralAgentConfig
from .input_message import InputMessage


class GeneralAgentRequest(UniversalBaseModel):
    """
    A chat request for the Athena SDK.
    """

    channel: typing.Optional[str] = pydantic.Field(default=None)
    """
    The channel through which the request is being made.
    """

    config: GeneralAgentConfig
    messages: typing.List[InputMessage] = pydantic.Field()
    """
    The messages to send to the agent. Each message should be a string (for text inputs) or a list of multimodal content parts.
    """

    thread_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional thread ID for conversation persistence. If not provided, a new thread will be created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
