# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PublicAssetOut(UniversalBaseModel):
    """
    Response model for a single asset with comprehensive metadata.
    """

    athena_converted_type: str = pydantic.Field()
    """
    File type after Athena processing/conversion (e.g., 'txt', 'pdf', 'md')
    """

    athena_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Internal metadata used by Athena system (e.g., {'source': 'kb', 'topic': 'insights'})
    """

    athena_original_type: str = pydantic.Field()
    """
    Original asset type from AssetType enum (e.g., 'document', 'presentation', 'spreadsheet')
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the asset was created (ISO 8601 format)
    """

    created_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of the user who created this asset
    """

    created_by_id: str = pydantic.Field()
    """
    Unique identifier of the user who created this asset
    """

    is_archived: bool = pydantic.Field()
    """
    Whether the asset has been archived (hidden from normal views)
    """

    is_hidden: bool = pydantic.Field()
    """
    Whether the asset is hidden from the user interface
    """

    media_type: str = pydantic.Field()
    """
    MIME type or Athena-specific media type (e.g., 'text/plain', 'application/pdf', 'athena/document')
    """

    summary: typing.Optional[str] = pydantic.Field(default=None)
    """
    AI-generated summary of the asset content
    """

    summary_ready: bool = pydantic.Field()
    """
    Whether the AI summary has been generated and is available
    """

    summary_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Status of summary generation process ('READY', 'PENDING', 'FAILED', etc.)
    """

    tags: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Custom tags associated with the asset as key-value pairs (e.g., {'project': 'alpha', 'team': 'ml'})
    """

    title: str = pydantic.Field()
    """
    Display name/title of the asset
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the asset was last modified (ISO 8601 format)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
