/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ByteBuffCollection {
    private static final Logger logger = LogManager.getLogger(ByteBuffCollection.class);
    private final List<ByteBuffer> buffers;

    public ByteBuffCollection() {
        this.buffers = new ArrayList<ByteBuffer>();
    }

    public ByteBuffCollection(int capacity) {
        this.buffers = new ArrayList<ByteBuffer>(capacity);
    }

    public ByteBuffCollection(ByteBuffer bb) {
        this();
        this.add(bb);
    }

    private ByteBuffCollection(List<ByteBuffer> buffers) {
        this.buffers = buffers;
    }

    public ByteBuffCollection add(ByteBuffer bb) {
        if (bb.position() != 0) {
            String stackTrace = String.join((CharSequence)"\n", Stream.of(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).toList());
            logger.warn("Passed non-flipped ByteBuffer: {}", (Object)stackTrace);
            bb.flip();
        }
        this.buffers.add(bb);
        return this;
    }

    public byte[] toSingleByteArray() {
        int bufferSize = this.buffers.stream().mapToInt(Buffer::limit).sum();
        byte[] ret = new byte[bufferSize];
        int offset = 0;
        logger.debug("Creating buffer of size {}", (Object)bufferSize);
        for (ByteBuffer bb : this.buffers) {
            bb.get(ret, offset, bb.limit());
            offset += bb.limit();
        }
        return ret;
    }

    public static ByteBuffCollection concat(ByteBuffCollection bbc1, ByteBuffCollection bbc2) {
        if (bbc1 == bbc2) {
            throw new IllegalArgumentException("bbc1 and bbc2 are the same");
        }
        return new ByteBuffCollection(Stream.concat(bbc1.buffers.stream(), bbc2.buffers.stream()).toList());
    }

    public static ByteBuffCollection concat(ByteBuffCollection bbc, ByteBuffer bb) {
        return new ByteBuffCollection(Stream.concat(bbc.buffers.stream(), Stream.of(bb)).toList());
    }

    public long size() {
        long ret = 0L;
        for (ByteBuffer bb : this.buffers) {
            ret += (long)bb.limit();
        }
        return ret;
    }

    public long writeTo(OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull(outputStream, "OutputStream cannot be null");
        long count = 0L;
        for (ByteBuffer bb : this.buffers) {
            outputStream.write(bb.array(), 0, bb.limit());
            count += (long)bb.limit();
        }
        return count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ByteBuffer bb : this.buffers) {
            sb.append(new String(bb.array(), 0, bb.limit(), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }
}

