/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JVMLauncher {
    private static final Logger logger = LogManager.getLogger(JVMLauncher.class);
    private static final Set<String> ARGUMENT_PREFIXES = Set.of("-X");
    private final List<String> jvmArgs;
    private final List<String> programArgs;

    public JVMLauncher(String[] args) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.jvmArgs = runtimeMXBean.getInputArguments().stream().filter(arg -> ARGUMENT_PREFIXES.stream().anyMatch(arg::startsWith)).collect(Collectors.toList());
        logger.debug("JVM memory arguments: {}", (Object)this.jvmArgs);
        this.programArgs = List.of(args);
        logger.debug("Program arguments: {}", (Object)this.programArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launchJar(Path jarPath) {
        ArrayList<String> command = new ArrayList<String>();
        File jarFile = jarPath.toFile();
        if (!jarFile.exists()) {
            logger.error("JAR file not found: {}", (Object)jarPath);
            return false;
        }
        command.add("java");
        command.addAll(this.jvmArgs);
        logger.debug("Java Version: {}", (Object)System.getProperty("java.version"));
        command.add("-XX:+IgnoreUnrecognizedVMOptions");
        command.add("--sun-misc-unsafe-memory-access=allow");
        command.add("--enable-native-access=ALL-UNNAMED");
        command.add("-jar");
        command.add(jarPath.toString());
        command.addAll(this.programArgs);
        logger.debug("CMD: {}", (Object)command);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(jarPath.toFile().getParentFile());
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            try {
                logger.debug("Started process: {}", (Object)process.pid());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Thread.sleep(1000L);
            if (!process.isAlive()) {
                return false;
            }
            JVMLauncher jVMLauncher = this;
            synchronized (jVMLauncher) {
                this.wait();
            }
            return process.isAlive();
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to launch JAR: {}", (Object)jarPath, (Object)e);
            return false;
        }
    }
}

