/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thetadata.config.ConfigurationManager;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarLibraryManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(JarLibraryManager.class);
    private static final Pattern JAR_VERSION_PATTERN = Pattern.compile("^(\\d{9}).jar$");
    private final ConfigurationManager configurationManager;
    private final CloseableHttpClient httpClient;
    private SortedSet<Path> jarList;

    public JarLibraryManager(ConfigurationManager configurationManager) {
        this(configurationManager, HttpClients.createDefault());
    }

    public JarLibraryManager(ConfigurationManager configurationManager, CloseableHttpClient httpClient) {
        boolean created;
        this.configurationManager = configurationManager;
        this.httpClient = httpClient;
        Path libraryDirectory = configurationManager.getJarDirectory();
        logger.debug("Library directory: {}", (Object)libraryDirectory);
        File libraryDirectoryFile = libraryDirectory.toFile();
        if (!libraryDirectoryFile.exists() && !(created = libraryDirectoryFile.mkdir())) {
            logger.error("Failed to create JAR library directory: {}", (Object)libraryDirectory);
            throw new RuntimeException("Failed to create JAR library directory: " + String.valueOf(libraryDirectory));
        }
        this.jarList = new TreeSet<Path>();
        try (Stream<Path> stream = Files.list(configurationManager.getJarDirectory());){
            this.jarList = stream.filter(path -> JAR_VERSION_PATTERN.matcher(path.getFileName().toString()).matches()).collect(Collectors.toCollection(TreeSet::new));
        }
        catch (Exception e) {
            logger.error("Error getting JARs in the library directory: {}", (Object)configurationManager.getJarDirectory());
            logger.debug("Error getting JARs in the library directory", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> fetchAssignedVersion() {
        try {
            URI versionUri = this.configurationManager.getVersionUri(this.configurationManager.getEmail());
            HttpGet request = new HttpGet(versionUri);
            logger.debug("Fetching assigned version at {}", (Object)versionUri);
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                HttpEntity entity = response.getEntity();
                if (response.getCode() == 200 && entity != null) {
                    String version = EntityUtils.toString(entity);
                    Optional<String> optional2 = Optional.of(version);
                    return optional2;
                }
                logger.warn("Failed to fetch version; code: {}", (Object)response.getCode());
                Optional<String> optional = Optional.empty();
                return optional;
            }
        }
        catch (Exception e) {
            logger.warn("Error fetching the version of the terminal to run: {}", (Object)e.getMessage());
            logger.debug("Error fetching the version of the terminal to run", e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadJarFile(String version) {
        Path jarFile = this.configurationManager.getJarDirectory().resolve(version + ".jar");
        try {
            URI downloadUri = this.configurationManager.getDownloadUri(version);
            HttpGet request = new HttpGet(downloadUri);
            logger.debug("Attempting to download {} to {}", (Object)downloadUri, (Object)jarFile);
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                HttpEntity entity = response.getEntity();
                if (response.getCode() == 200 && entity != null) {
                    try (InputStream inputStream = entity.getContent();){
                        Files.copy(inputStream, jarFile, StandardCopyOption.REPLACE_EXISTING);
                        if (this.jarList.size() >= Math.max(this.configurationManager.getMaxJars(), 2)) {
                            Path oldestJar = this.configurationManager.getJarDirectory().resolve(this.jarList.first());
                            boolean deleted = Files.deleteIfExists(oldestJar);
                            if (deleted) {
                                this.jarList.remove(oldestJar);
                            } else {
                                logger.warn("Failed to delete jar file: {}", (Object)oldestJar);
                            }
                        }
                        this.jarList.add(jarFile);
                        logger.debug("JAR file downloaded successfully to {} ", (Object)jarFile);
                        boolean bl = true;
                        return bl;
                    }
                }
                logger.warn("Failed to download JAR file. HTTP error code: {}", (Object)response.getCode());
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.warn("Error downloading JAR file: {}", (Object)e.getMessage());
            logger.debug("Error downloading JAR file", e);
            return false;
        }
    }

    public SortedSet<Path> getStoredJars() {
        return ImmutableSortedSet.copyOf(this.jarList);
    }

    public Optional<Path> findLatestJar() {
        if (this.jarList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.jarList.getLast());
    }

    public Optional<Path> findFallbackJar() {
        if (this.jarList.isEmpty() || this.jarList.size() == 1) {
            return Optional.empty();
        }
        return Optional.of((Path)this.jarList.stream().toList().get(this.jarList.size() - 2));
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }
}

