/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HttpsURLConnection;
import net.thetadata.User2;
import net.thetadata.enums.AccountType;
import net.thetadata.utils.Utils;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserValidator {
    private static final Logger logger = LogManager.getLogger(UserValidator.class);
    public static volatile String domain = "www.thetadata.net";
    private static final String FUNC_URL2 = "https://" + domain + "/_functions/verify3";

    private static void doRequest(String email, String pass, HttpsURLConnection con) throws IOException {
        String urlParameters = email + "," + pass;
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        con.setDoOutput(true);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("charset", "utf-8");
        con.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        con.setUseCaches(false);
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.write(postData);
        }
        con.setConnectTimeout(5000);
        con.setReadTimeout(5000);
    }

    public static User2 wixAuthenticate(String email, String pass) throws ExecutionException, InterruptedException, TimeoutException {
        FutureTask<User2> task = new FutureTask<User2>(() -> {
            int tries = 0;
            while (true) {
                JsonObject obj = null;
                try {
                    URL u = new URL(FUNC_URL2);
                    HttpsURLConnection con = (HttpsURLConnection)u.openConnection();
                    UserValidator.doRequest(email, pass, con);
                    obj = JsonParser.parseString(new String(con.getInputStream().readAllBytes(), StandardCharsets.UTF_8)).getAsJsonObject();
                    if (!obj.has("email")) {
                        throw new Exception("no email field: " + String.valueOf(obj));
                    }
                    String wixEmail = obj.get("email").getAsString();
                    if (!email.equals(wixEmail)) {
                        logger.error("Wix email and passed email don't match: {} != {}", (Object)wixEmail, (Object)email);
                    }
                    return new User2(obj.get("email").getAsString(), AccountType.from(obj.get("stock_plan").getAsString()), AccountType.from(obj.get("option_plan").getAsString()), AccountType.from(obj.get("index_plan").getAsString()), AccountType.from(obj.get("rate_plan").getAsString()));
                }
                catch (IllegalArgumentException iae) {
                    logger.error("Unknown account type for: {}", (Object)email, (Object)iae);
                    logger.debug("Wix response: {}", (Object)obj);
                    throw iae;
                }
                catch (Exception e) {
                    logger.debug("Error validating user: {}; try {} of 2", (Object)email, (Object)tries, (Object)e);
                    if (tries++ != 2) continue;
                    throw e;
                }
                break;
            }
        });
        ExecutorService exec = Executors.newFixedThreadPool(1);
        exec.submit(task);
        try {
            User2 out = task.get(10L, TimeUnit.SECONDS);
            exec.shutdownNow();
            return out;
        }
        catch (Exception e) {
            exec.shutdownNow();
            throw e;
        }
    }

    public static User2 nexusAuthenticate(String email, String pass) {
        return null;
    }

    public static void nexusUpsertUser(User2 user, String password) {
        String lastLogin = Instant.ofEpochMilli(user.getLastOnline()).atZone(ZoneId.systemDefault()).toOffsetDateTime().toString();
        String hostname = Utils.getHostname();
        JsonObject newUserObj = new JsonObject();
        newUserObj.addProperty("displayName", user.email());
        newUserObj.addProperty("email", user.getEmail());
        newUserObj.addProperty("password", password);
        newUserObj.addProperty("isRetail", true);
        newUserObj.addProperty("stockSubscription", user.getStkPlan().toFullString());
        newUserObj.addProperty("optionsSubscription", user.getOptPlan().toFullString());
        newUserObj.addProperty("indicesSubscription", user.getIdxPlan().toFullString());
        newUserObj.addProperty("interestRateSubscription", user.getRatePlan().toFullString());
        newUserObj.addProperty("lastLogin", lastLogin);
        newUserObj.addProperty("lastLoginHost", hostname);
        Gson gson = new Gson();
        String newUserJson = gson.toJson(newUserObj);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpEntity entity = EntityBuilder.create().setText(newUserJson).setContentType(ContentType.APPLICATION_JSON).build();
            HttpPut httpPut = new HttpPut("https://nexus-api.thetadata.us/identity/user");
            httpPut.setHeader("X-TD-KEY", "4feced2a-cdf1-11ef-87f9-6ff3812919fc");
            httpPut.setEntity(entity);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds(2L)).setResponseTimeout(Timeout.ofSeconds(2L)).build();
            httpPut.setConfig(requestConfig);
            httpclient.execute((ClassicHttpRequest)httpPut, response -> {
                logger.debug("Upserting Nexus user: {} {}-{}", (Object)user.getEmail(), (Object)response.getCode(), (Object)response.getReasonPhrase());
                EntityUtils.consume(response.getEntity());
                return null;
            });
        }
        catch (IOException e) {
            logger.error("Error while attempting to upsert user in Nexus: {}", (Object)e.getMessage());
        }
    }
}

