/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.thetadata.exceptions.BadConfigurationException;
import net.thetadata.provider.ConfigFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractConfigurationManager {
    private static final Logger logger = LogManager.getLogger(AbstractConfigurationManager.class);
    protected final Options options = new Options();
    private ConfigFile configFile = null;
    private File logDirectory;

    public AbstractConfigurationManager() {
        Option help = Option.builder("h").required(false).hasArg(false).desc("Print usage").longOpt("help").build();
        Option config = Option.builder().longOpt("config").required(false).hasArg(true).argName("config.toml").desc("Alternate configuration file; will use build-in if not set").build();
        Option logDir = Option.builder().required(false).hasArg().argName("log_directory").desc("Directory to store log files; defaults to ThetaData directory").longOpt("log-directory").build();
        Option debug = Option.builder().longOpt("debug").required(false).hasArg(false).build();
        this.options.addOption(help);
        this.options.addOption(config);
        this.options.addOption(logDir);
        this.options.addOption(debug);
    }

    protected abstract void parseCommandLine(CommandLine var1) throws Exception;

    public void parseArgs(String[] args) throws Exception {
        DefaultParser cmdParser = new DefaultParser();
        CommandLine commandLine = cmdParser.parse(this.options, args);
        if (commandLine.hasOption("h")) {
            this.handleHelp();
        }
        if (commandLine.hasOption("debug")) {
            System.setProperty("debug_logging", "ENABLE");
            logger.debug("Debug logging enabled");
        }
        if (commandLine.hasOption("config")) {
            File file = this.getConfigFile(commandLine.getOptionValue("config"));
            if (!file.exists()) {
                throw new FileNotFoundException("Config file not found. Attempted to read: " + file.getAbsolutePath());
            }
            this.configFile = new ConfigFile(file);
        } else if (this.allowWriteConfig()) {
            File file = this.getConfigFile(null);
            this.configFile = new ConfigFile(file);
        } else {
            this.configFile = new ConfigFile();
        }
        this.logDirectory = commandLine.hasOption("log-directory") ? new File(commandLine.getOptionValue("log-directory")) : (this.configFile.getString("log_directory") != null ? new File(this.configFile.getString("log_directory")) : new File("/tmp"));
        this.parseCommandLine(commandLine);
    }

    public String getString(String key) {
        String ret = this.configFile.getString(key);
        if (ret == null) {
            throw new BadConfigurationException("Key (" + key + ") not found in config file");
        }
        return ret;
    }

    public Long getLong(String key) {
        Long ret = this.configFile.getLong(key);
        if (ret == null) {
            throw new BadConfigurationException("Key (" + key + ") not found in config file");
        }
        return ret;
    }

    public int getInt(String key) {
        return Math.toIntExact(this.getLong(key));
    }

    public boolean getBoolean(String key) {
        Boolean ret = this.configFile.getBoolean(key);
        if (ret == null) {
            throw new BadConfigurationException("Key (" + key + ") not found in config file");
        }
        return ret;
    }

    public List<String> getStringList(String key) {
        List<String> list = this.configFile.getStringList(key);
        if (list == null) {
            throw new BadConfigurationException("Key (" + key + ") not found in config file");
        }
        return list;
    }

    public Path getConfigFilePath() throws FileNotFoundException {
        return this.configFile.getConfigFilePath();
    }

    public Path getLogDirectory() {
        return this.logDirectory.toPath().toAbsolutePath();
    }

    protected abstract void printUsage();

    protected abstract void handleHelp();

    protected abstract File getConfigFile(String var1) throws FileNotFoundException;

    protected abstract boolean allowWriteConfig();

    public void alternateConfigFile(ConfigFile configFile) {
        this.configFile = configFile;
    }

    public Map<String, Object> getConfigValues() {
        return this.configFile.getConfigValues();
    }
}

