/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.config;

import java.io.File;
import java.io.FileNotFoundException;
import net.thetadata.config.AbstractConfigurationManager;
import net.thetadata.config.CredentialFileParser;
import net.thetadata.generated.nexus.AuthRequest;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCredentialsConfigurationManager
extends AbstractConfigurationManager {
    private static final Logger logger = LogManager.getLogger(AbstractCredentialsConfigurationManager.class);
    private final CredentialFileParser credentialFileParser;
    private String email;
    private String password;
    protected final Option credsFileOption;

    public AbstractCredentialsConfigurationManager(CredentialFileParser credentialFileParser) {
        this.credentialFileParser = credentialFileParser;
        this.credsFileOption = Option.builder().longOpt("creds-file").required(false).hasArg().argName("creds.txt").desc("A 2-line text file containing username and password, each on their own line").build();
        this.options.addOption(this.credsFileOption);
    }

    @Override
    protected abstract void parseCommandLine(CommandLine var1) throws Exception;

    @Override
    public void parseArgs(String[] args) throws Exception {
        DefaultParser cmdParser = new DefaultParser();
        CommandLine commandLine = cmdParser.parse(this.options, args);
        super.parseArgs(args);
        String credentialFileOption = commandLine.getOptionValue("creds-file");
        File credentialFile = this.getCredentialsFile(credentialFileOption);
        if (!credentialFile.exists()) {
            logger.error("Credentials file not found, attempted to read: {}", (Object)credentialFile.getAbsolutePath());
            this.credentialFileParser.getCredentialsFromStdin(credentialFile);
        } else {
            logger.debug("Attempting to read config file: {}", (Object)credentialFile.getAbsolutePath());
            this.credentialFileParser.parseCredentialFile(credentialFile);
        }
        this.email = this.credentialFileParser.getEmail();
        this.password = this.credentialFileParser.getPassword();
    }

    public AuthRequest getAuthRequest() {
        AuthRequest ret = new AuthRequest();
        ret.email = this.email;
        ret.password = this.password;
        return ret;
    }

    public String getEmail() {
        return this.email;
    }

    protected abstract File getCredentialsFile(String var1) throws FileNotFoundException;
}

