/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Objects;
import net.thetadata.config.AbstractCredentialsConfigurationManager;
import net.thetadata.config.CredentialFileParser;
import net.thetadata.provider.ConfigFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationManager
extends AbstractCredentialsConfigurationManager {
    private static final Logger logger = LogManager.getLogger(ConfigurationManager.class);
    private static final HelpFormatter formatter = new HelpFormatter();
    private final Options helpOptions = new Options();
    private Boolean isVersionCheck;
    private String userVersion;
    private Path jarDirectory = null;
    private boolean terminalHelp = false;

    public ConfigurationManager(CredentialFileParser credentialFileParser) {
        super(credentialFileParser);
        Option bootstrapHelp = Option.builder().longOpt("bootstrap-help").required(false).hasArg(false).desc("Prints bootstrap terminal usage").build();
        Option versionCheck = Option.builder().longOpt("version-check").required(false).hasArg(false).desc("Prints the version to be run, and the versions available").build();
        Option userVersion = Option.builder().longOpt("user-version").required(false).hasArg().desc("Specify the version to use").build();
        Option bootstrapConfig = Option.builder().longOpt("bootstrap-config").required(false).hasArg().argName("bootstrap.toml").desc("Alternate configuration file; will use build-in if not set").build();
        this.options.addOption(bootstrapHelp);
        this.options.addOption(versionCheck);
        this.options.addOption(userVersion);
        this.options.addOption(bootstrapConfig);
        this.helpOptions.addOption(this.options.getOption("creds-file"));
        this.helpOptions.addOption(bootstrapHelp);
        this.helpOptions.addOption(versionCheck);
        this.helpOptions.addOption(userVersion);
    }

    @Override
    public void parseCommandLine(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption("bootstrap-help")) {
            this.handleBootstrapHelp();
        }
        if (commandLine.hasOption("bootstrap-config")) {
            File file = this.getConfigFile(commandLine.getOptionValue("bootstrap-config"));
            if (!file.exists()) {
                throw new FileNotFoundException("Config file not found. Attempted to read: " + file.getAbsolutePath());
            }
            super.alternateConfigFile(new ConfigFile(file));
        }
        this.isVersionCheck = commandLine.hasOption("version-check");
        this.userVersion = commandLine.getOptionValue("user-version");
    }

    @Override
    protected void handleHelp() {
        this.terminalHelp = true;
    }

    private void handleBootstrapHelp() {
        this.printUsage();
        System.exit(0);
    }

    @Override
    public void printUsage() {
        String newline = System.lineSeparator();
        formatter.printHelp(120, "java -jar ThetaTerminal.jar [options]", "See: https://http-docs.thetadata.us/Articles/Performance-And-Tuning/Launch-Arguments.html" + newline + newline + "options:", this.helpOptions, newline + "Note: A subscription is required to use the ThetaTerminal");
    }

    @Override
    protected File getCredentialsFile(String path) throws FileNotFoundException {
        return new File(Objects.requireNonNullElse(path, "creds.txt"));
    }

    @Override
    protected File getConfigFile(String path) throws FileNotFoundException {
        return new File(Objects.requireNonNullElse(path, "bootstrap.toml"));
    }

    public Boolean isVersionCheck() {
        return this.isVersionCheck;
    }

    public String getUserVersion() {
        return this.userVersion;
    }

    public Path getJarDirectory() {
        if (this.jarDirectory != null) {
            return this.jarDirectory;
        }
        String jarDirectoryString = this.getString("jar_directory");
        File jarDirectoryFile = new File(jarDirectoryString);
        if (jarDirectoryFile.isAbsolute()) {
            this.jarDirectory = jarDirectoryFile.toPath();
            logger.debug("Found absolute jar directory in config: {}", (Object)this.jarDirectory);
        } else {
            try {
                File jarFile = new File(ConfigurationManager.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                Path cwdPath = jarFile.getParentFile().toPath();
                this.jarDirectory = cwdPath.resolve(jarDirectoryString);
                logger.debug("Using CWD for jar directory: {}", (Object)this.jarDirectory);
            }
            catch (URISyntaxException e) {
                logger.error("Error getting working directory", (Throwable)e);
                throw new RuntimeException("Error getting working directory", e);
            }
        }
        return this.jarDirectory;
    }

    public URI getVersionUri() throws URISyntaxException {
        return this.getVersionUriBuilder().build();
    }

    public URI getVersionUri(String email) throws URISyntaxException {
        return this.getVersionUriBuilder().appendPath(email).build();
    }

    private URIBuilder getVersionUriBuilder() throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.getString("server.base_url"));
        uriBuilder.appendPath(this.getString("server.version_endpoint"));
        return uriBuilder;
    }

    public URI getDownloadUri(String version) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.getString("server.base_url"));
        uriBuilder.appendPath(this.getString("server.download_endpoint"));
        uriBuilder.appendPath(version);
        return uriBuilder.build();
    }

    public int getMaxJars() {
        return this.getLong("max_jars").intValue();
    }

    @Override
    protected boolean allowWriteConfig() {
        return false;
    }

    public boolean isTerminalHelp() {
        return this.terminalHelp;
    }
}

