/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.config;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CredentialFileParser {
    private static final Logger logger = LogManager.getLogger(CredentialFileParser.class);
    private final Console console;
    private String email;
    private String password;

    public CredentialFileParser(Console console) {
        this.console = console;
    }

    public void parseCredentialFile(File credentialFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(credentialFile, StandardCharsets.UTF_8));){
            this.email = Objects.requireNonNull(reader.readLine(), "Error reading first line of credential file: " + String.valueOf(credentialFile)).trim().toLowerCase(Locale.US);
            this.password = Objects.requireNonNull(reader.readLine(), "Error reading second line of credential file: " + String.valueOf(credentialFile)).trim();
            logger.debug("email: {}; password (length): {}", (Object)this.email, (Object)this.password.length());
        }
    }

    public void getCredentialsFromStdin(File credentialFile) throws IOException {
        Objects.requireNonNull(this.console, "No console to read credentials from");
        this.email = this.console.readLine("Please enter the email address associated with your Theta Data account: ", new Object[0]);
        this.password = new String(this.console.readPassword("Please enter your Theta Data password (characters won't display): ", new Object[0]));
        logger.debug("email: {}; password (length): {}", (Object)this.email, (Object)this.password.length());
        Files.writeString(credentialFile.toPath(), (CharSequence)(this.email + System.lineSeparator() + this.password), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }
}

