/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.enums;

public enum RateType {
    SOFR,
    TREASURY_M1,
    TREASURY_M3,
    TREASURY_M6,
    TREASURY_Y1,
    TREASURY_Y2,
    TREASURY_Y3,
    TREASURY_Y5,
    TREASURY_Y7,
    TREASURY_Y10,
    TREASURY_Y20,
    TREASURY_Y30;


    public static RateType from(String rateType) {
        if (rateType.isBlank()) {
            return SOFR;
        }
        return switch (rateType.toLowerCase()) {
            case "sofr" -> SOFR;
            case "treasury_m1" -> TREASURY_M1;
            case "treasury_m3" -> TREASURY_M3;
            case "treasury_m6" -> TREASURY_M6;
            case "treasury_y1" -> TREASURY_Y1;
            case "treasury_y2" -> TREASURY_Y2;
            case "treasury_y3" -> TREASURY_Y3;
            case "treasury_y5" -> TREASURY_Y5;
            case "treasury_y7" -> TREASURY_Y7;
            case "treasury_y10" -> TREASURY_Y10;
            case "treasury_y20" -> TREASURY_Y20;
            case "treasury_y30" -> TREASURY_Y30;
            default -> throw new IllegalArgumentException("Unknown rate type: " + rateType);
        };
    }
}

