/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.exceptions;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public abstract class ClientException
extends Exception {
    public static final Metadata.Key<String> HTTP_STATUS_CODE = Metadata.Key.of("http_status_code", Metadata.ASCII_STRING_MARSHALLER);
    private final int clientStatusCode;
    private final Status status;

    public ClientException(String message, int clientStatusCode, Status status) {
        super(message);
        this.clientStatusCode = clientStatusCode;
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getClientStatusCode() {
        return this.clientStatusCode;
    }

    public StatusRuntimeException asStatusRuntimeException() {
        Metadata trailers = new Metadata();
        trailers.put(HTTP_STATUS_CODE, String.valueOf(this.clientStatusCode));
        return this.status.withDescription(super.getMessage()).asRuntimeException(trailers);
    }
}

