/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.provider;

import com.google.common.collect.ImmutableList;
import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigFile {
    private static final Logger logger = LogManager.getLogger(ConfigFile.class);
    private final Toml config;
    private final Toml defaultConfig;
    private final File configFile;

    public ConfigFile(File configFile) throws IOException {
        this.configFile = configFile;
        try (InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("default_config.toml");){
            this.defaultConfig = new Toml().read(Objects.requireNonNull(defaultConfigStream, "Could not locate default_config.toml; contact support: support@thetadata.net"));
        }
        if (!configFile.exists()) {
            try {
                defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("default_config.toml");
                try (FileOutputStream outFile = new FileOutputStream(configFile);){
                    defaultConfigStream.transferTo(outFile);
                    logger.info("Configuration file not found, wrote default to: {}", (Object)configFile.getAbsolutePath());
                }
                finally {
                    if (defaultConfigStream != null) {
                        defaultConfigStream.close();
                    }
                }
            }
            catch (IOException e) {
                logger.error("Error while writing default configuration to {}", (Object)configFile.getAbsolutePath());
                throw e;
            }
        }
        this.config = new Toml().read(configFile);
    }

    public ConfigFile() throws IOException {
        this.configFile = null;
        try (InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("default_config.toml");){
            this.defaultConfig = new Toml().read(Objects.requireNonNull(defaultConfigStream, "Could not locate default_config.toml; contact support: support@thetadata.net"));
        }
        this.config = new Toml().read(InputStream.nullInputStream());
    }

    public Path getConfigFilePath() throws FileNotFoundException {
        if (this.configFile == null) {
            try {
                return Path.of(Objects.requireNonNull(this.getClass().getClassLoader().getResource("default_config.toml")).toURI());
            }
            catch (Exception e) {
                throw new FileNotFoundException("Could not locate default_config.toml; contact support: support@thetadata.net");
            }
        }
        return this.configFile.toPath();
    }

    public List<String> getStringList(String key) {
        List ret = this.config.getList(key);
        if (ret == null) {
            ret = this.defaultConfig.getList(key);
        }
        return ImmutableList.copyOf(ret);
    }

    public Long getLong(String key) {
        Long ret = this.config.getLong(key);
        if (ret == null) {
            ret = this.defaultConfig.getLong(key);
        }
        return ret;
    }

    public String getString(String key) {
        String ret = this.config.getString(key);
        if (ret == null) {
            ret = this.defaultConfig.getString(key);
        }
        return ret;
    }

    public Boolean getBoolean(String key) {
        Boolean ret = this.config.getBoolean(key);
        if (ret == null) {
            ret = this.defaultConfig.getBoolean(key);
        }
        return ret;
    }

    public Map<String, Object> getConfigValues() {
        Map<String, Object> configMap = this.defaultConfig.toMap();
        configMap.putAll(this.config.toMap());
        return configMap;
    }
}

