/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import net.thetadata.types.tick.TradeTick;

public class Price
implements Comparable<Price> {
    private static final String ZERO_CHAR = "0";
    private final int value;
    private final int type;

    public Price(TradeTick tradeTick) {
        this(tradeTick.price(), tradeTick.priceType());
    }

    public Price(net.thetadata.generated.Price price) {
        this(price.getValue(), price.getType());
    }

    public Price(int value, int type) {
        Preconditions.checkArgument(0 <= type && type < 20, "Price type must be between 0 and 20: " + type);
        this.value = value;
        this.type = type;
    }

    public boolean isZero() {
        return this.value == 0 || this.type == 0;
    }

    public int getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public net.thetadata.generated.Price toPriceMessage() {
        return net.thetadata.generated.Price.newBuilder().setValue(this.value).setType(this.type).build();
    }

    public static net.thetadata.generated.Price getPriceMessage(TradeTick tradeTick) {
        return net.thetadata.generated.Price.newBuilder().setValue(tradeTick.price()).setType(tradeTick.priceType()).build();
    }

    @Override
    public int compareTo(Price other) {
        if (this.type > other.type) {
            int exp = this.type - other.type;
            return Longs.compare(LongMath.checkedMultiply(this.value, LongMath.checkedPow(10L, exp)), other.value);
        }
        if (other.type > this.type) {
            int exp = other.type - this.type;
            return Longs.compare(this.value, LongMath.checkedMultiply(other.value, LongMath.checkedPow(10L, exp)));
        }
        return Ints.compare(this.value, other.value);
    }

    public int hashCode() {
        return this.value ^ this.type;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Price)) {
            return false;
        }
        return this.compareTo((Price)other) == 0;
    }

    public String toString() {
        Object valueString;
        if (this.type == 0) {
            return "0.0";
        }
        if (this.type == 10) {
            return String.format("%d.0", this.value);
        }
        if (this.type > 10) {
            return this.value + ZERO_CHAR.repeat(this.type - 10) + ".0";
        }
        boolean isNegative = this.value < 0;
        Object object = valueString = isNegative ? String.valueOf(this.value).substring(1) : String.valueOf(this.value);
        if (((String)valueString).length() < 10 - this.type + 1) {
            valueString = ZERO_CHAR.repeat(10 - this.type - ((String)valueString).length() + 1) + (String)valueString;
        }
        String ret = ((String)valueString).substring(0, ((String)valueString).length() - (10 - this.type)) + "." + ((String)valueString).substring(((String)valueString).length() - (10 - this.type));
        return isNegative ? "-" + ret : ret;
    }
}

