/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types;

import net.thetadata.exceptions.BadRequestException;

public enum Right {
    CALL,
    PUT,
    BOTH;


    public static Right from(String right) throws BadRequestException {
        if (right.isBlank()) {
            return BOTH;
        }
        return switch (right.toLowerCase()) {
            case "call", "c" -> CALL;
            case "put", "p" -> PUT;
            case "both", "b" -> BOTH;
            default -> throw new BadRequestException("Invalid right: " + right);
        };
    }

    public static Right from(char right) throws BadRequestException {
        return switch (right) {
            case 'C', 'c' -> CALL;
            case 'P', 'p' -> PUT;
            case '*', 'B', 'b' -> BOTH;
            default -> throw new BadRequestException("Invalid right: " + right);
        };
    }

    public char toChar() {
        return switch (this.ordinal()) {
            case 0 -> 'C';
            case 1 -> 'P';
            default -> throw new IllegalArgumentException("Attempting to convert BOTH right into a character");
        };
    }
}

