/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import net.thetadata.generated.Price;
import net.thetadata.generated.TimeZone;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.tick.Tick;
import net.thetadata.utils.TimeUtils;

public class OhlcTick {
    private final int[] data;

    public OhlcTick(Tick tick) {
        this.data = tick.data();
        if (this.data.length != 9) {
            throw new IllegalArgumentException("OHLC tick data length must be 10");
        }
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int open() {
        return this.data[1];
    }

    public Price openPrice() {
        return Price.newBuilder().setValue(this.open()).setType(this.priceType()).build();
    }

    public int high() {
        return this.data[2];
    }

    public Price highPrice() {
        return Price.newBuilder().setValue(this.high()).setType(this.priceType()).build();
    }

    public int low() {
        return this.data[3];
    }

    public Price lowPrice() {
        return Price.newBuilder().setValue(this.low()).setType(this.priceType()).build();
    }

    public int close() {
        return this.data[4];
    }

    public Price closePrice() {
        return Price.newBuilder().setValue(this.close()).setType(this.priceType()).build();
    }

    public int volume() {
        return this.data[5];
    }

    public int count() {
        return this.data[6];
    }

    public int priceType() {
        return this.data[7];
    }

    public int date() {
        return this.data[8];
    }

    public ZonedDateTime getDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }
}

