/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import net.thetadata.generated.TimeZone;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.tick.Tick;
import net.thetadata.utils.TimeUtils;

public class OpenInterestTick {
    private final int[] data;

    public OpenInterestTick(Tick t2) {
        this.data = t2.data();
        if (this.data.length != 3) {
            throw new IllegalArgumentException("Wrong number of data fields, expecting 3, got " + this.data.length);
        }
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int openInterest() {
        return this.data[1];
    }

    public int date() {
        return this.data[2];
    }

    public ZonedDateTime getDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }
}

