/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Tick
implements Cloneable {
    protected final int[] data;
    private static final int DEFAULT_CAPACITY = 8;

    public Tick(int capacity) {
        this.data = new int[capacity];
    }

    public Tick(int[] data) {
        this.data = new int[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public Tick serialize(DataOutputStream os) throws IOException {
        os.writeInt(this.data.length);
        for (int datum : this.data) {
            os.writeInt(datum);
        }
        return this;
    }

    public Tick readID(int ... firstData) {
        System.arraycopy(firstData, 1, this.data, 0, this.data.length + 1 - 1);
        return this;
    }

    public static Tick deserialize(DataInputStream is) throws IOException {
        Tick out = new Tick(is.readInt());
        for (int i = 0; i < out.capacity(); ++i) {
            out.data[i] = is.readInt();
        }
        return out;
    }

    public Tick read(int ... firstData) {
        System.arraycopy(firstData, 0, this.data, 0, this.data.length);
        return this;
    }

    public Tick readID(int[] firstData, int len) {
        for (int i = 1; i < len; ++i) {
            this.data[i - 1] = firstData[i] + this.data[i - 1];
        }
        return this;
    }

    public Tick read(boolean keepDate, int ... firstData) {
        if (keepDate) {
            if (this.data.length - 1 >= 0) {
                System.arraycopy(firstData, 0, this.data, 0, this.data.length - 1);
            }
        } else {
            System.arraycopy(firstData, 0, this.data, 0, this.data.length);
        }
        return this;
    }

    public Tick read(int[] firstData, Tick prev, int len) {
        for (int i = 0; i < len; ++i) {
            this.data[i] = firstData[i] + prev.data[i];
        }
        if (len == -1 || len == 0) {
            return this;
        }
        if (firstData.length - len >= 0) {
            System.arraycopy(prev.data, len, this.data, len, firstData.length - len);
        }
        return this;
    }

    public void write(ByteBuffer buff, int size) {
        for (int i = 0; i < size; ++i) {
            buff.putInt(this.data[i]);
        }
    }

    public void put(int key, int value) {
        this.data[key % this.data.length] = value;
    }

    public int time() {
        return this.data[0];
    }

    public void setTime(int time) {
        this.data[0] = time;
    }

    public int capacity() {
        return this.data.length;
    }

    public int[] data() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.data, ((Tick)obj).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public Tick clone() {
        int[] newData = new int[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        return new Tick(newData);
    }
}

