/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import net.thetadata.generated.TimeZone;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.Price;
import net.thetadata.types.tick.Tick;
import net.thetadata.utils.TimeUtils;

public class TradeTick
extends Tick {
    public TradeTick(Tick t2) {
        super(t2.data());
        if (this.data.length != 16) {
            throw new IllegalArgumentException("Wrong number of data fields, expecting 16, got " + this.data.length);
        }
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int sequence() {
        return this.data[1];
    }

    public int extCon1() {
        return this.data[2];
    }

    public int extCon2() {
        return this.data[3];
    }

    public int extCon3() {
        return this.data[4];
    }

    public int extCon4() {
        return this.data[5];
    }

    public int condition() {
        return this.data[6];
    }

    public int size() {
        return this.data[7];
    }

    public int exchange() {
        return this.data[8];
    }

    public int price() {
        return this.data[9];
    }

    public int conditionFlags() {
        return this.data[10];
    }

    public int priceFlags() {
        return this.data[11];
    }

    public int volumeType() {
        return this.data[12];
    }

    public int recordsBack() {
        return this.data[13];
    }

    public int priceType() {
        return this.data[14];
    }

    public int date() {
        return this.data[15];
    }

    public int[] getDataArray() {
        return this.data;
    }

    public Price getPrice() {
        return new Price(this.price(), this.priceType());
    }

    @Override
    public TradeTick clone() {
        return new TradeTick(super.clone());
    }

    public ZonedDateTime getDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }

    public net.thetadata.generated.Price getPriceMessage() {
        return net.thetadata.generated.Price.newBuilder().setValue(this.price()).setType(this.priceType()).build();
    }

    public boolean isCancelled() {
        return 40 <= this.condition() && this.condition() <= 44;
    }

    public boolean tradeConditionNoLast() {
        return (this.conditionFlags() & 1) == 1;
    }

    public boolean priceConditionSetLast() {
        return (this.priceFlags() & 1) == 1;
    }

    public boolean isIncrementalVolume() {
        return this.volumeType() == 0;
    }

    public boolean regularTradingHours() {
        return 34200000 <= this.msOfDay() && this.msOfDay() <= 57600000;
    }

    public boolean isSeller() {
        return this.extCon1() == 12;
    }
}

